/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalIntByteMapOps;
import net.openhft.koloboke.collect.map.IntByteMap;
import net.openhft.koloboke.function.IntByteConsumer;
import net.openhft.koloboke.function.IntBytePredicate;

public final class CommonIntByteMapOps {
    public static boolean containsAllEntries(final InternalIntByteMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof IntByteMap) {
            IntByteMap m2 = (IntByteMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalIntByteMapOps) {
                return ((InternalIntByteMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new IntBytePredicate(){

                public boolean test(int a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Integer)e.getKey(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalIntByteMapOps map, Map<? extends Integer, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof IntByteMap) {
            if (another instanceof InternalIntByteMapOps) {
                ((InternalIntByteMapOps)another).reversePutAllTo(map);
            } else {
                ((IntByteMap)another).forEach(new IntByteConsumer(){

                    public void accept(int key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Integer, ? extends Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonIntByteMapOps() {
    }
}

