/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Collection;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalLongCollectionOps;
import net.openhft.koloboke.collect.set.LongSet;

public final class CommonLongCollectionOps {
    public static boolean containsAll(final LongCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof LongCollection) {
            LongCollection c2 = (LongCollection)another;
            if (collection instanceof LongSet && c2 instanceof LongSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalLongCollectionOps) {
                return ((InternalLongCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Long)o).longValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(LongCollection collection, Collection<? extends Long> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof LongCollection) {
            if (another instanceof InternalLongCollectionOps) {
                return ((InternalLongCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements LongConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ LongCollection val$collection;

                AddAll(LongCollection longCollection) {
                    this.val$collection = longCollection;
                }

                @Override
                public void accept(long value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((LongCollection)another).forEach((LongConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Long l : another) {
            collectionChanged |= collection.add(l.longValue());
        }
        return collectionChanged;
    }

    private CommonLongCollectionOps() {
    }
}

