/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalLongLongMapOps;
import net.openhft.koloboke.collect.map.LongLongMap;
import net.openhft.koloboke.function.LongLongConsumer;
import net.openhft.koloboke.function.LongLongPredicate;

public final class CommonLongLongMapOps {
    public static boolean containsAllEntries(final InternalLongLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongLongMap) {
            LongLongMap m2 = (LongLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongLongMapOps) {
                return ((InternalLongLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongLongPredicate(){

                public boolean test(long a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Long)e.getKey(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongLongMapOps map, Map<? extends Long, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongLongMap) {
            if (another instanceof InternalLongLongMapOps) {
                ((InternalLongLongMapOps)another).reversePutAllTo(map);
            } else {
                ((LongLongMap)another).forEach(new LongLongConsumer(){

                    public void accept(long key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonLongLongMapOps() {
    }
}

