/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalLongShortMapOps;
import net.openhft.koloboke.collect.map.LongShortMap;
import net.openhft.koloboke.function.LongShortConsumer;
import net.openhft.koloboke.function.LongShortPredicate;

public final class CommonLongShortMapOps {
    public static boolean containsAllEntries(final InternalLongShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof LongShortMap) {
            LongShortMap m2 = (LongShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalLongShortMapOps) {
                return ((InternalLongShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new LongShortPredicate(){

                public boolean test(long a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Long)e.getKey(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalLongShortMapOps map, Map<? extends Long, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof LongShortMap) {
            if (another instanceof InternalLongShortMapOps) {
                ((InternalLongShortMapOps)another).reversePutAllTo(map);
            } else {
                ((LongShortMap)another).forEach(new LongShortConsumer(){

                    public void accept(long key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Long, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonLongShortMapOps() {
    }
}

