/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalShortObjMapOps;
import net.openhft.koloboke.collect.map.ShortObjMap;
import net.openhft.koloboke.function.ShortObjConsumer;
import net.openhft.koloboke.function.ShortObjPredicate;

public final class CommonShortObjMapOps {
    public static boolean containsAllEntries(final InternalShortObjMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortObjMap) {
            ShortObjMap m2 = (ShortObjMap)another;
            if (m2.valueEquivalence().equals((Object)map.valueEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalShortObjMapOps) {
                    return ((InternalShortObjMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ShortObjPredicate(){

                public boolean test(short a, Object b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <V> void putAll(final InternalShortObjMapOps<V> map, Map<? extends Short, ? extends V> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortObjMap) {
            if (another instanceof InternalShortObjMapOps) {
                ((InternalShortObjMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortObjMap)another).forEach(new ShortObjConsumer<V>(){

                    public void accept(short key, V value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<Short, V> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortObjMapOps() {
    }
}

