/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.hash.CharHashFactory;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.AbstractHashFactory;

abstract class CharHashFactorySO
extends AbstractHashFactory {
    final char lower;
    final char upper;
    final boolean randomFree;
    final boolean randomRemoved;
    final char freeValue;
    final char removedValue;

    CharHashFactorySO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize);
        this.lower = lower;
        this.upper = upper;
        if ((char)(lower - '\u0001') == upper) {
            this.randomFree = false;
            this.randomRemoved = true;
            this.removedValue = '\u0000';
            this.freeValue = '\u0000';
        } else {
            this.randomFree = false;
            this.freeValue = lower < upper && (lower > '\u0000' || upper < '\u0000') || upper < lower && lower > '\u0000' && upper < '\u0000' ? (char)'\u0000' : (char)(lower - '\u0001');
            if ((char)(lower - 2) == upper) {
                this.randomRemoved = true;
                this.removedValue = '\u0000';
            } else {
                this.randomRemoved = false;
                this.removedValue = upper + '\u0001' != 0 ? (char)(upper + '\u0001') : (char)(upper + 2);
            }
        }
    }

    public final char getLowerKeyDomainBound() {
        return this.lower;
    }

    public final char getUpperKeyDomainBound() {
        return this.upper;
    }

    char getFree() {
        if (this.randomFree) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return (char)((Random)random).nextInt();
        }
        return this.freeValue;
    }

    String keySpecialString() {
        return ",lowerKeyDomainBound=" + CharHashFactorySO.boundAsString(this.getLowerKeyDomainBound()) + ",upperKeyDomainBound=" + CharHashFactorySO.boundAsString(this.getUpperKeyDomainBound());
    }

    private static String boundAsString(char bound) {
        return String.format("%04x", bound);
    }

    int keySpecialHashCode(int hashCode) {
        hashCode = hashCode * 31 + Primitives.hashCode(this.getLowerKeyDomainBound());
        return hashCode * 31 + Primitives.hashCode(this.getUpperKeyDomainBound());
    }

    boolean keySpecialEquals(CharHashFactory other) {
        return this.getLowerKeyDomainBound() == other.getLowerKeyDomainBound() && this.getUpperKeyDomainBound() == other.getUpperKeyDomainBound();
    }
}

