/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.AbstractShortValueView;
import net.openhft.koloboke.collect.impl.CommonCharShortMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalCharShortMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.ImmutableLHashParallelKVCharShortMapSO;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.ParallelKVCharShortLHash;
import net.openhft.koloboke.collect.map.CharShortCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.CharShortConsumer;
import net.openhft.koloboke.function.CharShortPredicate;
import net.openhft.koloboke.function.CharShortToShortFunction;
import net.openhft.koloboke.function.CharToShortFunction;
import net.openhft.koloboke.function.ShortBinaryOperator;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public class ImmutableLHashParallelKVCharShortMapGO
extends ImmutableLHashParallelKVCharShortMapSO {
    final void copy(ParallelKVCharShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(char key, short value) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public short get(char key) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(k) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public short getOrDefault(char key, short defaultValue) {
        char free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVCharKeyMixing.mix(key) & capacityMask;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (char)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Character, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(Character.valueOf(key), (Short)((short)(entry >>> 16)));
        }
    }

    public void forEach(CharShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            action.accept(key, (short)(entry >>> 16));
        }
    }

    public boolean forEachWhile(CharShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || predicate.test(key, (short)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public CharShortCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalCharShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free || m.containsEntry(key, (short)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalCharShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            m.justPut(key, (short)(entry >>> 16));
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Character, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            hashCode += key ^ (short)(entry >>> 16);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        char free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            char key = (char)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((short)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Short put(Character key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short put(char key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short putIfAbsent(Character key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short putIfAbsent(char key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(char key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short compute(Character key, BiFunction<? super Character, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short compute(char key, CharShortToShortFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short computeIfAbsent(Character key, Function<? super Character, ? extends Short> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short computeIfAbsent(char key, CharToShortFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short computeIfPresent(Character key, BiFunction<? super Character, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short computeIfPresent(char key, CharShortToShortFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short merge(Character key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short merge(char key, short value, ShortBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short addValue(char key, short value) {
        throw new UnsupportedOperationException();
    }

    public short addValue(char key, short addition, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Character, ? extends Short> m) {
        CommonCharShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Character key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short replace(char key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Character key, Short oldValue, Short newValue) {
        return this.replace(key.charValue(), (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(char key, short oldValue, short newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Character, ? super Short, ? extends Short> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(CharShortToShortFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(char key) {
        throw new UnsupportedOperationException();
    }

    public short remove(char key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Short)value);
    }

    public boolean remove(char key, short value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(CharShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements CharShortCursor {
        final int[] tab;
        final char free;
        int index;
        char curKey;
        short curValue;

        NoRemovedMapCursor() {
            char free;
            this.tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue);
        }

        public void forEachForward(CharShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (short)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final int[] tab;
        final char free;
        int index;
        char curKey;
        short curValue;

        NoRemovedValueCursor() {
            char free;
            this.tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (short)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final int[] tab;
        final char free;
        int nextIndex;
        short next;

        NoRemovedValueIterator() {
            this.tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            char free = this.free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                char free = this.free;
                short prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    if ((char)entry == free) continue;
                    this.next = (short)(entry >>> 16);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Short>> {
        final int[] tab;
        final char free;
        int index;
        char curKey;
        short curValue;

        NoRemovedEntryCursor() {
            char free;
            this.tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (short)(entry >>> 16)));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Short> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            char free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (short)(entry >>> 16);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Short>> {
        final int[] tab;
        final char free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            char free = this.free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                char free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (short)(entry >>> 16));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVCharShortMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVCharShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableLHashParallelKVCharShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return ImmutableLHashParallelKVCharShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || predicate.test((short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free || c.contains((short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= c.add((short)(entry >>> 16));
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                changed |= s.removeShort((short)(entry >>> 16));
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ShortCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                sb.append(' ').append((short)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return ImmutableLHashParallelKVCharShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVCharShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends CharShortEntry {
        private char key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends CharShortEntry {
        private final char key;
        private final short value;

        ImmutableEntry(char key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    abstract class CharShortEntry
    extends AbstractEntry<Character, Short> {
        CharShortEntry() {
        }

        abstract char key();

        @Override
        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Short>>
    implements HashObjSet<Map.Entry<Character, Short>>,
    InternalObjCollectionOps<Map.Entry<Character, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableLHashParallelKVCharShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableLHashParallelKVCharShortMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableLHashParallelKVCharShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableLHashParallelKVCharShortMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (short)(entry >>> 16));
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (short)(entry >>> 16));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, (short)(entry >>> 16)));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test(new ImmutableEntry(key, (short)(entry >>> 16)))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Character, Short>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Short>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (short)(entry >>> 16)));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableLHashParallelKVCharShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            char free = ImmutableLHashParallelKVCharShortMapGO.this.freeValue;
            int[] tab = ImmutableLHashParallelKVCharShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableLHashParallelKVCharShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                short value = (Short)e.getValue();
                return ImmutableLHashParallelKVCharShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableLHashParallelKVCharShortMapGO.this.clear();
        }
    }
}

