/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.AbstractShortValueView;
import net.openhft.koloboke.collect.impl.CommonLongShortMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalLongShortMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashSeparateKVLongShortMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVLongShortQHash;
import net.openhft.koloboke.collect.map.LongShortCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.LongShortConsumer;
import net.openhft.koloboke.function.LongShortPredicate;
import net.openhft.koloboke.function.LongShortToShortFunction;
import net.openhft.koloboke.function.LongToShortFunction;
import net.openhft.koloboke.function.ShortBinaryOperator;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public class ImmutableQHashSeparateKVLongShortMapGO
extends ImmutableQHashSeparateKVLongShortMapSO {
    @Override
    final void copy(SeparateKVLongShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(long key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(long key, short defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Long)key, (Short)vals[i]);
        }
    }

    public void forEach(LongShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(LongShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public LongShortCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long free = this.freeValue;
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Short put(Long key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short put(long key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short putIfAbsent(Long key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short putIfAbsent(long key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(long key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short compute(Long key, BiFunction<? super Long, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short compute(long key, LongShortToShortFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short computeIfAbsent(Long key, Function<? super Long, ? extends Short> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short computeIfAbsent(long key, LongToShortFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short computeIfPresent(Long key, BiFunction<? super Long, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short computeIfPresent(long key, LongShortToShortFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short merge(Long key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short merge(long key, short value, ShortBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public short addValue(long key, short value) {
        throw new UnsupportedOperationException();
    }

    public short addValue(long key, short addition, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Short> m) {
        CommonLongShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Long key, Short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short replace(long key, short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Long key, Short oldValue, Short newValue) {
        return this.replace((long)key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(long key, short oldValue, short newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Short, ? extends Short> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(LongShortToShortFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public short remove(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Short)value);
    }

    public boolean remove(long key, short value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements LongShortCursor {
        final long[] keys;
        final short[] vals;
        final long free;
        int index;
        long curKey;
        short curValue;

        NoRemovedMapCursor() {
            long free;
            this.keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue);
        }

        public void forEachForward(LongShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        final long free;
        int index;
        long curKey;
        short curValue;

        NoRemovedValueCursor() {
            long free;
            this.keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        final long free;
        int nextIndex;
        short next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                short prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Short>> {
        final long[] keys;
        final short[] vals;
        final long free;
        int index;
        long curKey;
        short curValue;

        NoRemovedEntryCursor() {
            long free;
            this.keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Short> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            long free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Short>> {
        final long[] keys;
        final short[] vals;
        final long free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            long free = this.free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            short[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                long free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVLongShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return ImmutableQHashSeparateKVLongShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Short)vals[i]);
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeShort(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ShortCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return ImmutableQHashSeparateKVLongShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVLongShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends LongShortEntry {
        private long key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends LongShortEntry {
        private final long key;
        private final short value;

        ImmutableEntry(long key, short value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    abstract class LongShortEntry
    extends AbstractEntry<Long, Short> {
        LongShortEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Short>>
    implements HashObjSet<Map.Entry<Long, Short>>,
    InternalObjCollectionOps<Map.Entry<Long, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVLongShortMapGO.this.containsEntry((Long)e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Short>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Short>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            long free = ImmutableQHashSeparateKVLongShortMapGO.this.freeValue;
            long[] keys = ImmutableQHashSeparateKVLongShortMapGO.this.set;
            short[] vals = ImmutableQHashSeparateKVLongShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVLongShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                short value = (Short)e.getValue();
                return ImmutableQHashSeparateKVLongShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVLongShortMapGO.this.clear();
        }
    }
}

