/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.hash.LHashIntSetFactoryGO;
import net.openhft.koloboke.collect.impl.hash.QHashIntSetFactoryImpl;
import net.openhft.koloboke.collect.set.hash.HashIntSetFactory;

public final class LHashIntSetFactoryImpl
extends LHashIntSetFactoryGO {
    public LHashIntSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public LHashIntSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashIntSetFactory thisWith(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        return new LHashIntSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashIntSetFactory qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        return new QHashIntSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    HashIntSetFactory lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, int lower, int upper) {
        return new LHashIntSetFactoryImpl(hashConf, defaultExpectedSize, lower, upper);
    }

    HashIntSetFactory withDomain(int lower, int upper) {
        if (lower == this.getLowerKeyDomainBound() && upper == this.getUpperKeyDomainBound()) {
            return this;
        }
        return new LHashIntSetFactoryImpl(this.getHashConfig(), this.getDefaultExpectedSize(), lower, upper);
    }

    public HashIntSetFactory withKeysDomain(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minPossibleKey shouldn't be greater than maxPossibleKey");
        }
        return this.withDomain(lower, upper);
    }

    public HashIntSetFactory withKeysDomainComplement(int lower, int upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("minImpossibleKey shouldn't be greater than maxImpossibleKey");
        }
        return this.withDomain(upper + 1, lower - 1);
    }
}

