/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ByteCollection;
import net.openhft.koloboke.collect.ByteCursor;
import net.openhft.koloboke.collect.ByteIterator;
import net.openhft.koloboke.collect.DoubleCollection;
import net.openhft.koloboke.collect.DoubleCursor;
import net.openhft.koloboke.collect.DoubleIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractDoubleValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonByteDoubleMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalByteDoubleMapOps;
import net.openhft.koloboke.collect.impl.InternalDoubleCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashSeparateKVByteDoubleMapSO;
import net.openhft.koloboke.collect.impl.hash.MutableSeparateKVByteLHashGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVByteDoubleLHash;
import net.openhft.koloboke.collect.map.ByteDoubleCursor;
import net.openhft.koloboke.collect.set.DoubleSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashByteSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.ByteDoubleConsumer;
import net.openhft.koloboke.function.ByteDoublePredicate;
import net.openhft.koloboke.function.ByteDoubleToDoubleFunction;
import net.openhft.koloboke.function.BytePredicate;
import net.openhft.koloboke.function.ByteToDoubleFunction;

public class MutableLHashSeparateKVByteDoubleMapGO
extends MutableLHashSeparateKVByteDoubleMapSO {
    @Override
    final void copy(SeparateKVByteDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteDoubleLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    @Override
    public boolean containsEntry(byte key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(byte key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    public double getOrDefault(byte key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Byte, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept((Byte)key, (Double)Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteDoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, Double.longBitsToDouble(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteDoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteDoubleCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteDoubleMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalByteDoubleMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalByteDoubleMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Byte, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Double.longBitsToDouble(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        byte[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        long[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double put(Byte key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public double put(byte key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public Double putIfAbsent(Byte key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public double putIfAbsent(byte key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public void justPut(byte key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Double.doubleToLongBits(value);
    }

    @Override
    public void justPut(byte key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Double compute(Byte key, BiFunction<? super Byte, ? super Double, ? extends Double> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Byte)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = Double.doubleToLongBits(newValue);
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)k, (Double)Double.longBitsToDouble(vals[index]))) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public double compute(byte key, ByteDoubleToDoubleFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public Double computeIfAbsent(Byte key, Function<? super Byte, ? extends Double> mappingFunction) {
        Double value;
        byte k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVByteKeyMixing.mix(k) & capacityMask;
        byte cur = keys[index];
        if (cur == k) {
            return Double.longBitsToDouble(vals[index]);
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return Double.longBitsToDouble(vals[index]);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Byte)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = Double.doubleToLongBits(value);
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(byte key, ByteToDoubleFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        byte[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
        byte cur = keys[index];
        if (cur == key) {
            return Double.longBitsToDouble(vals[index]);
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return Double.longBitsToDouble(vals[index]);
            } while (cur != free);
        }
        double value = mappingFunction.applyAsDouble(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = Double.doubleToLongBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Double computeIfPresent(Byte key, BiFunction<? super Byte, ? super Double, ? extends Double> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            Double newValue = remappingFunction.apply((Byte)k, (Double)Double.longBitsToDouble(vals[index]));
            if (newValue != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public double computeIfPresent(byte key, ByteDoubleToDoubleFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Double merge(Byte key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Double)Double.longBitsToDouble(vals[index]), value)) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public double merge(byte key, double value, DoubleBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(byte key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        double newValue = Double.longBitsToDouble(vals[index]) + value;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(byte key, double addition, double defaultValue) {
        double value = defaultValue + addition;
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        double newValue = Double.longBitsToDouble(vals[index]) + addition;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Byte, ? extends Double> m) {
        CommonByteDoubleMapOps.putAll(this, m);
    }

    @Override
    public Double replace(Byte key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    @Override
    public double replace(byte key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Byte key, Double oldValue, Double newValue) {
        return this.replace((byte)key, (double)oldValue, (double)newValue);
    }

    @Override
    public boolean replace(byte key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == Double.doubleToLongBits(oldValue)) {
                vals[index] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Byte, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            vals[i] = Double.doubleToLongBits(function.apply((Byte)key, (Double)Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteDoubleToDoubleFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        byte keyToShift;
        int indexToRemove;
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = free;
        this.postRemoveHook();
    }

    @Override
    public Double remove(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix(k) & capacityMask;
            byte cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            long[] vals = this.values;
            double val = Double.longBitsToDouble(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            long[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public double remove(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            byte keyToShift;
            int indexToRemove;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            long[] vals = this.values;
            double val = Double.longBitsToDouble(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Double)value);
    }

    public boolean remove(byte key, double value) {
        byte free = this.freeValue;
        if (key != free) {
            long[] vals;
            byte[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVByteKeyMixing.mix(key) & capacityMask;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((vals = this.values)[index] == Double.doubleToLongBits(value)) {
                byte keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ByteDoublePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !filter.test(key, Double.longBitsToDouble(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Byte> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(BytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                byte key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll(thisC, (ByteCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                byte key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                byte key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, byte delayedRemoved) {
        byte free = this.freeValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            byte keyToShift;
            int indexToRemove;
            if (keys[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    @Override
    public ByteIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ByteCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements ByteDoubleCursor {
        byte[] keys;
        long[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue);
        }

        public void forEachForward(ByteDoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(double value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = Double.doubleToLongBits(value);
            if (this.vals == MutableLHashSeparateKVByteDoubleMapGO.this.values) return;
            MutableLHashSeparateKVByteDoubleMapGO.this.values[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        byte[] keys;
        long[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue);
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public double elem() {
            if (this.curKey != this.free) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        byte[] keys;
        long[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            byte free = this.free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Double.longBitsToDouble(vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(keys[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Double>> {
        byte[] keys;
        long[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Double> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, byte key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVByteDoubleMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVByteDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Double>> {
        byte[] keys;
        long[] vals;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            byte free = this.free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry2(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVByteDoubleMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(keys[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, byte key, long value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(long newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVByteDoubleMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVByteDoubleMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashSeparateKVByteDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableLHashSeparateKVByteDoubleMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(long bits) {
            return MutableLHashSeparateKVByteDoubleMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Double)Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Double.longBitsToDouble(vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableLHashSeparateKVByteDoubleMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeDouble(long bits) {
            return MutableLHashSeparateKVByteDoubleMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVByteDoubleMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !filter.test((Double)Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !filter.test(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    byte key = keys[i];
                    if (key == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    byte key = keys[i];
                    if (key == free || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ByteDoubleEntry {
        private byte key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteDoubleEntry {
        final int modCount;
        private final int index;
        final byte key;
        private long value;

        MutableEntry(int modCount, int index, byte key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableLHashSeparateKVByteDoubleMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ByteDoubleEntry
    extends AbstractEntry<Byte, Double> {
        ByteDoubleEntry() {
        }

        abstract byte key();

        @Override
        public final Byte getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Double>>
    implements HashObjSet<Map.Entry<Byte, Double>>,
    InternalObjCollectionOps<Map.Entry<Byte, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Double>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVByteDoubleMapGO.this.containsEntry((byte)((Byte)e.getKey()), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Byte, Double>> iterator() {
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Double>> cursor() {
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVByteDoubleMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                double value = (Double)e.getValue();
                return MutableLHashSeparateKVByteDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    byte key = keys[i];
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    byte key = keys[i];
                    if (key == free || !c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVByteDoubleMapGO.this.modCount();
            byte free = MutableLHashSeparateKVByteDoubleMapGO.this.freeValue;
            byte[] keys = MutableLHashSeparateKVByteDoubleMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            byte delayedRemoved = 0;
            long[] vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    byte key = keys[i];
                    if (key == free || c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        byte keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVByteDoubleMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVByteDoubleMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVByteLHashGO.NoRemovedCursor {
        long[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVByteDoubleMapGO.this, mc);
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVByteLHashGO.NoRemovedIterator {
        long[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVByteDoubleMapGO.this, mc);
            this.vals = MutableLHashSeparateKVByteDoubleMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVByteDoubleMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            if (keys == MutableLHashSeparateKVByteDoubleMapGO.this.set) {
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVByteDoubleMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVByteKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVByteDoubleMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVByteDoubleMapGO.this.justRemove(keys[index]);
            }
        }
    }
}

