/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.impl.IntArrays;
import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.MutableQHash;
import net.openhft.koloboke.collect.impl.hash.ParallelKVIntQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;

public abstract class MutableParallelKVIntQHashSO
extends MutableQHash
implements ParallelKVIntQHash,
PrimitiveConstants,
UnsafeConstants {
    int freeValue;
    int removedValue;
    long[] table;

    void copy(ParallelKVIntQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = (long[])hash.table().clone();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    void move(ParallelKVIntQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = hash.table();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    final void init(HashConfigWrapper configWrapper, int size, int freeValue, int removedValue) {
        this.freeValue = freeValue;
        this.removedValue = removedValue;
        super.init(configWrapper, size);
    }

    @Override
    public int freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return true;
    }

    @Override
    public int removedValue() {
        return this.removedValue;
    }

    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private int findNewFreeOrRemoved() {
        int newFree;
        int free = this.freeValue;
        int removed = this.removedValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextInt()) == free || newFree == removed || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    int changeFree() {
        int mc = this.modCount();
        int newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        IntArrays.replaceAllKeys(this.table, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    int changeRemoved() {
        int mc = this.modCount();
        int newRemoved = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ++mc;
        if (!this.noRemoved()) {
            IntArrays.replaceAllKeys(this.table, this.removedValue, newRemoved);
        }
        this.removedValue = newRemoved;
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newRemoved;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity];
        if (this.freeValue != 0) {
            IntArrays.fillKeys(this.table, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        IntArrays.fillKeys(this.table, this.freeValue);
    }

    @Override
    void removeAt(int index) {
        U.putInt(this.table, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3), this.removedValue);
    }
}

