/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.impl.LongArrays;
import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVLongLHash;

public abstract class MutableSeparateKVLongLHashSO
extends MutableLHash
implements SeparateKVLongLHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long[] set;

    void copy(SeparateKVLongLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (long[])hash.keys().clone();
    }

    void move(SeparateKVLongLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public long removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free) {
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            long cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private long findNewFreeOrRemoved() {
        long newFree;
        long free = this.freeValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextLong()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    long changeFree() {
        int mc = this.modCount();
        long newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        LongArrays.replaceAll(this.set, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new long[capacity];
        if (this.freeValue != 0L) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

