/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.hash.ByteHashFactory;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.hash.HashContainerFactory;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashByteSetGO;
import net.openhft.koloboke.collect.impl.hash.LHashCapacities;
import net.openhft.koloboke.collect.impl.hash.MutableQHashByteSetGO;
import net.openhft.koloboke.collect.impl.hash.QHashByteSetFactorySO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVByteQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashByteSetGO;
import net.openhft.koloboke.collect.set.hash.HashByteSet;
import net.openhft.koloboke.collect.set.hash.HashByteSetFactory;
import net.openhft.koloboke.function.ByteConsumer;
import net.openhft.koloboke.function.Predicate;

public abstract class QHashByteSetFactoryGO
extends QHashByteSetFactorySO {
    public QHashByteSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashByteSetFactory thisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteSetFactory lHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    abstract HashByteSetFactory qHashLikeThisWith(HashConfig var1, int var2, byte var3, byte var4);

    public final HashByteSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashByteSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashByteSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashByteSetFactory) {
            HashByteSetFactory factory = (HashByteSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((ByteHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableQHashByteSetGO shrunk(UpdatableQHashByteSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public MutableQHashByteSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elements) {
        return this.newUpdatableSet((Iterable)elements, QHashByteSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2) {
        long expectedSize = QHashByteSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems2, 0)));
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3) {
        long expectedSize = QHashByteSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems3, 0)));
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4) {
        long expectedSize = QHashByteSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems4, 0)));
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5) {
        long expectedSize = QHashByteSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)QHashByteSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elements, int expectedSize) {
        return this.shrunk((UpdatableQHashByteSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableQHashByteSetGO set, Iterable<? extends Byte> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Byte> iterator = elems.iterator();
            while (iterator.hasNext()) {
                byte e = iterator.next();
                set.add(e);
            }
        }
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        QHashByteSetFactoryGO.addAll(set, elems1);
        QHashByteSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        QHashByteSetFactoryGO.addAll(set, elems1);
        QHashByteSetFactoryGO.addAll(set, elems2);
        QHashByteSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        QHashByteSetFactoryGO.addAll(set, elems1);
        QHashByteSetFactoryGO.addAll(set, elems2);
        QHashByteSetFactoryGO.addAll(set, elems3);
        QHashByteSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        QHashByteSetFactoryGO.addAll(set, elems1);
        QHashByteSetFactoryGO.addAll(set, elems2);
        QHashByteSetFactoryGO.addAll(set, elems3);
        QHashByteSetFactoryGO.addAll(set, elems4);
        QHashByteSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterator<Byte> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Iterator<Byte> elements, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Consumer<ByteConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Consumer<ByteConsumer> elementsSupplier, int expectedSize) {
        final UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept(new ByteConsumer(){

            public void accept(byte e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(byte[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(byte[] elements, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        for (byte e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Byte[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSet(Byte[] elements, int expectedSize) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(expectedSize);
        Byte[] byteArray = elements;
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byte e = byteArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSetOf(byte e1) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSetOf(byte e1, byte e2) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSetOf(byte e1, byte e2, byte e3) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSetOf(byte e1, byte e2, byte e3, byte e4) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public UpdatableQHashByteSetGO newUpdatableSetOf(byte e1, byte e2, byte e3, byte e4, byte e5, byte ... restElements) {
        UpdatableQHashByteSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (byte e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elements, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elements) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterator<Byte> elements) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Iterator<Byte> elements, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Consumer<ByteConsumer> elementsSupplier) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Consumer<ByteConsumer> elementsSupplier, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(byte[] elements) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(byte[] elements, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Byte[] elements) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSet(Byte[] elements, int expectedSize) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2, byte e3) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2, byte e3, byte e4) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashByteSet newMutableSetOf(byte e1, byte e2, byte e3, byte e4, byte e5, byte ... restElements) {
        MutableQHashByteSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elements, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elements) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterable<Byte> elems1, Iterable<Byte> elems2, Iterable<Byte> elems3, Iterable<Byte> elems4, Iterable<Byte> elems5) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterator<Byte> elements) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Iterator<Byte> elements, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Consumer<ByteConsumer> elementsSupplier) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Consumer<ByteConsumer> elementsSupplier, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVByteQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(byte[] elements) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(byte[] elements, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Byte[] elements) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSet(Byte[] elements, int expectedSize) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3, byte e4) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashByteSet newImmutableSetOf(byte e1, byte e2, byte e3, byte e4, byte e5, byte ... restElements) {
        ImmutableQHashByteSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

