/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashShortSet;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashShortSetGO;
import net.openhft.koloboke.collect.impl.hash.MutableQHashShortSet;
import net.openhft.koloboke.collect.impl.hash.MutableQHashShortSetGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortQHash;
import net.openhft.koloboke.collect.impl.hash.ShortQHashFactory;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashShortSet;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashShortSetGO;
import net.openhft.koloboke.collect.set.hash.HashShortSetFactory;

public abstract class QHashShortSetFactorySO
extends ShortQHashFactory<MutableQHashShortSetGO>
implements HashShortSetFactory {
    QHashShortSetFactorySO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashShortSetGO createNewMutable(int expectedSize, short free, short removed) {
        MutableQHashShortSet set = new MutableQHashShortSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashShortSetGO uninitializedMutableSet() {
        return new MutableQHashShortSet();
    }

    UpdatableQHashShortSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashShortSet();
    }

    ImmutableQHashShortSetGO uninitializedImmutableSet() {
        return new ImmutableQHashShortSet();
    }

    @Nonnull
    public MutableQHashShortSetGO newMutableSet(int expectedSize) {
        return (MutableQHashShortSetGO)this.newMutableHash(expectedSize);
    }

    @Nonnull
    public UpdatableQHashShortSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashShortSet set = new UpdatableQHashShortSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableQHashShortSetGO newUpdatableSet(Iterable<Short> elements, int expectedSize) {
        if (elements instanceof ShortCollection) {
            SeparateKVShortQHash hash;
            if (elements instanceof SeparateKVShortQHash && (hash = (SeparateKVShortQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashShortSet set = new UpdatableQHashShortSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashShortSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashShortSetGO set = this.newUpdatableSet(size);
        for (short e : elements) {
            set.add(e);
        }
        return set;
    }
}

