/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.IntCursor;
import net.openhft.koloboke.collect.impl.CommonIntCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalIntCollectionOps;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVIntLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableIntLHashSetSO;
import net.openhft.koloboke.collect.set.hash.HashIntSet;

public class UpdatableLHashIntSetGO
extends UpdatableIntLHashSetSO
implements HashIntSet,
InternalIntCollectionOps {
    @Override
    final void copy(SeparateKVIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonIntCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public IntCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Integer e) {
        return this.add((int)e);
    }

    public boolean add(int key) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVIntKeyMixing.mix(key) & capacityMask;
        int cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Integer> c) {
        return CommonIntCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeInt((Integer)key);
    }

    @Override
    boolean justRemove(int key) {
        return this.removeInt(key);
    }

    public boolean removeInt(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

