/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalShortByteMapOps;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortByteLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHashSeparateKVShortKeyMap;
import net.openhft.koloboke.collect.map.hash.HashShortByteMap;

public abstract class UpdatableLHashSeparateKVShortByteMapSO
extends UpdatableLHashSeparateKVShortKeyMap
implements HashShortByteMap,
InternalShortByteMapOps,
SeparateKVShortByteLHash {
    byte[] values;

    void copy(SeparateKVShortByteLHash hash) {
        super.copy(hash);
        this.values = (byte[])hash.valueArray().clone();
    }

    void move(SeparateKVShortByteLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public byte[] valueArray() {
        return this.values;
    }

    int valueIndex(byte value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(byte value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Byte)value);
    }

    int insert(short key, byte value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        short[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
        short cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new byte[capacity];
    }
}

