/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.DoubleCursor;
import net.openhft.koloboke.collect.impl.CommonDoubleCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalDoubleCollectionOps;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVDoubleQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableDoubleQHashSetSO;
import net.openhft.koloboke.collect.set.hash.HashDoubleSet;

public class UpdatableQHashDoubleSetGO
extends UpdatableDoubleQHashSetSO
implements HashDoubleSet,
InternalDoubleCollectionOps {
    @Override
    final void copy(SeparateKVDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonDoubleCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public DoubleCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Double e) {
        return this.add((double)e);
    }

    @Override
    public boolean add(long key) {
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == key) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean add(double key) {
        return this.add(Double.doubleToLongBits(key));
    }

    public boolean addAll(@Nonnull Collection<? extends Double> c) {
        return CommonDoubleCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeDouble((Double)key);
    }

    @Override
    boolean justRemove(long key) {
        return this.removeDouble(key);
    }

    @Override
    public boolean removeDouble(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeDouble(double key) {
        return this.removeDouble(Double.doubleToLongBits(key));
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

