/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.IntCollection;
import net.openhft.koloboke.collect.IntCursor;
import net.openhft.koloboke.collect.IntIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractIntValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonFloatIntMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatIntMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.ParallelKVFloatIntQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashParallelKVFloatIntMapSO;
import net.openhft.koloboke.collect.map.FloatIntCursor;
import net.openhft.koloboke.collect.set.IntSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.FloatIntConsumer;
import net.openhft.koloboke.function.FloatIntPredicate;
import net.openhft.koloboke.function.FloatIntToIntFunction;
import net.openhft.koloboke.function.FloatToIntFunction;

public class UpdatableQHashParallelKVFloatIntMapGO
extends UpdatableQHashParallelKVFloatIntMapSO {
    final void copy(ParallelKVFloatIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVFloatIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            step += 2;
        }
    }

    @Override
    public boolean containsEntry(int key, int value) {
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            step += 2;
        }
    }

    @Override
    public Integer get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return null;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            step += 2;
        }
    }

    public int get(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return this.defaultValue();
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            step += 2;
        }
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            step += 2;
        }
    }

    public int getOrDefault(float key, int defaultValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == k) {
                return (int)(entry >>> 32);
            }
            if (cur == 0x7FFFFFFE) {
                return defaultValue;
            }
            step += 2;
        }
    }

    @Override
    public void forEach(BiConsumer<? super Float, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatIntCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Float, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            int index = QHash.ParallelKVFloatKeyMixing.mix(key) % capacity;
            if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3)) != 0x7FFFFFFE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)bIndex << 3)) == 0x7FFFFFFE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)fIndex << 3)) == 0x7FFFFFFE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer put(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    @Override
    public int put(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    @Override
    public Integer putIfAbsent(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                this.incrementModCount();
                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                this.incrementModCount();
                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            step += 2;
        }
    }

    @Override
    public int putIfAbsent(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                this.incrementModCount();
                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                this.incrementModCount();
                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            step += 2;
        }
    }

    @Override
    public void justPut(float key, int value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    @Override
    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    @Override
    public Integer compute(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        long entry;
        int index;
        long[] tab;
        int k;
        block12: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                Integer newValue2;
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue2.intValue() << 32;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Integer)((int)(entry >>> 32)))) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public int compute(float key, FloatIntToIntFunction remappingFunction) {
        int newValue;
        long entry;
        int index;
        long[] tab;
        int k;
        block10: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), (int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public Integer computeIfAbsent(Float key, Function<? super Float, ? extends Integer> mappingFunction) {
        Integer value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur != 0x7FFFFFFE) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public int computeIfAbsent(float key, FloatToIntFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur != 0x7FFFFFFE) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return (int)(entry >>> 32);
                }
                if (cur == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int value = mappingFunction.applyAsInt(Float.intBitsToFloat(k));
        this.incrementModCount();
        tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return value;
    }

    @Override
    public Integer computeIfPresent(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                step += 2;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Integer)((int)(entry >>> 32)))) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
    }

    public int computeIfPresent(float key, FloatIntToIntFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        int newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), (int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public Integer merge(Float key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        long entry;
        int index;
        long[] tab;
        block12: {
            int k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)((int)(entry >>> 32)), value)) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public int merge(float key, int value, IntBinaryOperator remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block10: {
            int k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            }
        }
        int newValue = remappingFunction.applyAsInt((int)(entry >>> 32), value);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public int addValue(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int newValue = (int)(entry >>> 32) + value;
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public int addValue(float key, int addition, int defaultValue) {
        int k = Float.floatToIntBits(key);
        int value = defaultValue + addition;
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == 0x7FFFFFFE) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        int newValue = (int)(entry >>> 32) + addition;
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Float, ? extends Integer> m) {
        CommonFloatIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return null;
                }
                step += 2;
            }
        }
        int oldValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return oldValue;
    }

    @Override
    public int replace(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        int oldValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return oldValue;
    }

    @Override
    public boolean replace(Float key, Integer oldValue, Integer newValue) {
        return this.replace(key.floatValue(), (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(float key, int oldValue, int newValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVFloatKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        if ((int)(entry >>> 32) == oldValue) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return true;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Float, ? super Integer, ? extends Integer> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.apply(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatIntToIntFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.applyAsInt(Float.intBitsToFloat(key), (int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public int remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Integer)value);
    }

    public boolean remove(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements FloatIntCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public int elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        int next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry >= 0x7FFFFFFE) continue;
                        this.next = (int)(entry >>> 32);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Integer>> {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Integer>> {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashParallelKVFloatIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return UpdatableQHashParallelKVFloatIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public IntCursor cursor() {
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return UpdatableQHashParallelKVFloatIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVFloatIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends FloatIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatIntEntry {
        final int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            int oldValue = this.value;
            this.value = unwrappedNewValue = newValue.intValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putInt(UpdatableQHashParallelKVFloatIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class FloatIntEntry
    extends AbstractEntry<Float, Integer> {
        FloatIntEntry() {
        }

        abstract int key();

        @Override
        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Integer>>
    implements HashObjSet<Map.Entry<Float, Integer>>,
    InternalObjCollectionOps<Map.Entry<Float, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashParallelKVFloatIntMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (int)((Integer)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || predicate.test(new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Float, Integer>> iterator() {
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Integer>> cursor() {
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableQHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVFloatIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                int value = (Integer)e.getValue();
                return UpdatableQHashParallelKVFloatIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVFloatIntMapGO.this.clear();
        }
    }
}

