/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalLongCharMapOps;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVLongCharQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashSeparateKVLongKeyMap;
import net.openhft.koloboke.collect.map.hash.HashLongCharMap;

public abstract class UpdatableQHashSeparateKVLongCharMapSO
extends UpdatableQHashSeparateKVLongKeyMap
implements HashLongCharMap,
InternalLongCharMapOps,
SeparateKVLongCharQHash {
    char[] values;

    void copy(SeparateKVLongCharQHash hash) {
        super.copy(hash);
        this.values = (char[])hash.valueArray().clone();
    }

    void move(SeparateKVLongCharQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public char[] valueArray() {
        return this.values;
    }

    int valueIndex(char value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == free || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(char value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Character)value).charValue());
    }

    int insert(long key, char value) {
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVLongKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return index;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return bIndex;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return fIndex;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new char[capacity];
    }
}

