/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.CharIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractCharValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCharMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjCharMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ObjHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjCharQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashSeparateKVObjCharMapSO;
import net.openhft.koloboke.collect.map.ObjCharCursor;
import net.openhft.koloboke.collect.set.CharSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.CharBinaryOperator;
import net.openhft.koloboke.function.CharConsumer;
import net.openhft.koloboke.function.CharPredicate;
import net.openhft.koloboke.function.ObjCharConsumer;
import net.openhft.koloboke.function.ObjCharPredicate;
import net.openhft.koloboke.function.ObjCharToCharFunction;
import net.openhft.koloboke.function.ToCharFunction;

public class UpdatableQHashSeparateKVObjCharMapGO<K>
extends UpdatableQHashSeparateKVObjCharMapSO<K> {
    @Override
    final void copy(SeparateKVObjCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(Object key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char getChar(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public char getOrDefault(Object key, char defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, Character.valueOf(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjCharConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjCharPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjCharCursor<K> cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjCharMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjCharMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        char[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
            if (newKeys[index] != FREE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == FREE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == FREE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character put(K key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    @Override
    public char put(K key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Character putIfAbsent(K key, Character value) {
        int index = this.insert(key, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    @Override
    public char putIfAbsent(K key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(K key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Character compute(K key, BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    if ((newValue = remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[index] = key;
                        vals[index] = newValue.charValue();
                        this.postInsertHook();
                        return newValue;
                    }
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply(key, Character.valueOf(vals[index]))) != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
        }
        return this.computeNullKey(remappingFunction);
    }

    Character computeNullKey(BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        block12: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Character newValue2;
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = newValue2.charValue();
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(null, Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public char compute(K key, ObjCharToCharFunction<? super K> remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    newValue = remappingFunction.applyAsChar(key, this.defaultValue());
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
            }
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    char computeNullKey(ObjCharToCharFunction<? super K> remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsChar(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(null, vals[index]);
        return newValue;
    }

    @Override
    public Character computeIfAbsent(K key, Function<? super K, ? extends Character> mappingFunction) {
        if (key != null) {
            Character value;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            char[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur == key) {
                return Character.valueOf(vals[index]);
            }
            if (cur != FREE) {
                if (this.keyEquals(key, cur)) {
                    return Character.valueOf(vals[index]);
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return Character.valueOf(vals[bIndex]);
                    }
                    if (cur == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (this.keyEquals(key, cur)) {
                        return Character.valueOf(vals[bIndex]);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return Character.valueOf(vals[fIndex]);
                    }
                    if (cur == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (this.keyEquals(key, cur)) {
                        return Character.valueOf(vals[fIndex]);
                    }
                    step += 2;
                }
            }
            if ((value = mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value.charValue();
                this.postInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Character computeIfAbsentNullKey(Function<? super K, ? extends Character> mappingFunction) {
        Character value;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        char[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur == null) {
            return Character.valueOf(vals[index]);
        }
        if (cur != FREE) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    return Character.valueOf(vals[bIndex]);
                }
                if (cur == FREE) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    return Character.valueOf(vals[fIndex]);
                }
                if (cur == FREE) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        if ((value = mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = value.charValue();
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(K key, ToCharFunction<? super K> mappingFunction) {
        if (key != null) {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            char[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur == key) {
                return vals[index];
            }
            if (cur != FREE) {
                if (this.keyEquals(key, cur)) {
                    return vals[index];
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return vals[bIndex];
                    }
                    if (cur == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (this.keyEquals(key, cur)) {
                        return vals[bIndex];
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return vals[fIndex];
                    }
                    if (cur == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (this.keyEquals(key, cur)) {
                        return vals[fIndex];
                    }
                    step += 2;
                }
            }
            char value = mappingFunction.applyAsChar(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    char computeIfAbsentNullKey(ToCharFunction<? super K> mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        Object[] keys = this.set;
        char[] vals = this.values;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur == null) {
            return vals[index];
        }
        if (cur != FREE) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    return vals[bIndex];
                }
                if (cur == FREE) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    return vals[fIndex];
                }
                if (cur == FREE) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        char value = mappingFunction.applyAsChar(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Character computeIfPresent(K key, BiFunction<? super K, ? super Character, ? extends Character> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = remappingFunction.apply(key, Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public char computeIfPresent(K key, ObjCharToCharFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Character merge(K key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        if (key != null) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value.charValue();
                    this.postInsertHook();
                    return value;
                }
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Character mergeNullKey(Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        block12: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value.charValue();
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public char merge(K key, char value, CharBinaryOperator remappingFunction) {
        if (key != null) {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacity = keys.length;
            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            cur = keys[index];
            if (cur != key) {
                if (cur != UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                    if (!this.keyEquals(key, cur)) {
                        bIndex = index;
                        fIndex = index;
                        step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = bIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break;
                            }
                            t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break;
                            }
                            if (cur == UpdatableQHashSeparateKVObjCharMapGO.FREE) {
                                index = fIndex;
                                ** break;
                            }
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postInsertHook();
                    return value;
                }
            }
            vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    char mergeNullKey(char value, CharBinaryOperator remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block10: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                if (cur != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == null) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == null) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    public char addValue(K key, char value) {
        char newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    public char addValue(K key, char addition, char defaultValue) {
        char newValue;
        char value = (char)(defaultValue + addition);
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Character> m) {
        CommonObjCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(K key, Character value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public char replace(K key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Character oldValue, Character newValue) {
        return this.replace(key, oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(K key, char oldValue, char newValue) {
        int index = this.index(key);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = function.apply(key, Character.valueOf(vals[i])).charValue();
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjCharToCharFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            vals[i] = function.applyAsChar(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Character removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public char removeAsChar(Object key) {
        throw new UnsupportedOperationException();
    }

    char removeAsCharNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, ((Character)value).charValue());
    }

    public boolean remove(Object key, char value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjCharPredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjCharCursor<K> {
        final K[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjCharConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final K[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public char elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final K[] keys;
        final char[] vals;
        int expectedModCount;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Character>> {
        final K[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Character> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Character>> {
        final K[] keys;
        final char[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVObjCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return UpdatableQHashSeparateKVObjCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeChar(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return UpdatableQHashSeparateKVObjCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjCharEntry {
        private K key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjCharEntry {
        final int modCount;
        private final int index;
        final K key;
        private char value;

        MutableEntry(int modCount, int index, K key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UpdatableQHashSeparateKVObjCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjCharEntry
    extends AbstractEntry<K, Character> {
        ObjCharEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                char v2 = ((Character)e2.getValue()).charValue();
                return UpdatableQHashSeparateKVObjCharMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Character>>
    implements HashObjSet<Map.Entry<K, Character>>,
    InternalObjCollectionOps<Map.Entry<K, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Character>> equivalence() {
            return Equivalence.entryEquivalence(UpdatableQHashSeparateKVObjCharMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVObjCharMapGO.this.containsEntry(e.getKey(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Character>> iterator() {
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Character>> cursor() {
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVObjCharMapGO.this.modCount();
            Object[] keys = UpdatableQHashSeparateKVObjCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVObjCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVObjCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVObjCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                char value = ((Character)e.getValue()).charValue();
                return UpdatableQHashSeparateKVObjCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVObjCharMapGO.this.clear();
        }
    }
}

