/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalObjDoubleMapOps;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjDoubleQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashSeparateKVObjKeyMap;
import net.openhft.koloboke.collect.map.hash.HashObjDoubleMap;

public abstract class UpdatableQHashSeparateKVObjDoubleMapSO<K>
extends UpdatableQHashSeparateKVObjKeyMap<K>
implements HashObjDoubleMap<K>,
InternalObjDoubleMapOps<K>,
SeparateKVObjDoubleQHash {
    long[] values;

    void copy(SeparateKVObjDoubleQHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVObjDoubleQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        throw new UnsupportedOperationException();
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(K key, long value) {
        if (key != null) {
            Object[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == FREE) {
                        index = bIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return bIndex;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == FREE) {
                        index = fIndex;
                        break;
                    }
                    if (cur == key || this.keyEquals(key, cur)) {
                        return fIndex;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.values[index] = value;
            this.postInsertHook();
            return -1;
        }
        return this.insertNullKey(value);
    }

    int insertNullKey(long value) {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return index;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == FREE) {
                    index = bIndex;
                    break;
                }
                if (cur == null) {
                    return bIndex;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == FREE) {
                    index = fIndex;
                    break;
                }
                if (cur == null) {
                    return fIndex;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

