/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.impl.IntArrays;
import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVIntLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHash;

public abstract class UpdatableSeparateKVIntLHashSO
extends UpdatableLHash
implements SeparateKVIntLHash,
PrimitiveConstants,
UnsafeConstants {
    int freeValue;
    int[] set;

    void copy(SeparateKVIntLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (int[])hash.keys().clone();
    }

    void move(SeparateKVIntLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, int freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public int freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public int removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Integer)key);
    }

    public boolean contains(int key) {
        return this.index(key) >= 0;
    }

    int index(int key) {
        int free = this.freeValue;
        if (key != free) {
            int[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVIntKeyMixing.mix(key) & capacityMask;
            int cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private int findNewFreeOrRemoved() {
        int newFree;
        int free = this.freeValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    int changeFree() {
        int mc = this.modCount();
        int newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        IntArrays.replaceAll(this.set, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new int[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

