/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.impl.hash.UpdatableSeparateKVShortLHashSO;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashShortSet;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public abstract class UpdatableSeparateKVShortLHashGO
extends UpdatableSeparateKVShortLHashSO {
    @Override
    @Nonnull
    public short[] keys() {
        return this.set;
    }

    @Override
    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept((Short)key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(ShortCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ShortCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ShortSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            changed |= s.removeShort(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public ShortIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public ShortCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public short[] toShortArray() {
        int size = this.size();
        short[] result = new short[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public short[] toArray(short[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new short[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            hashCode += key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        short[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(short var1);

    public boolean removeIf(Predicate<? super Short> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            return this.retainAll(thisC, (ShortCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements ShortCursor {
        final short[] keys;
        final short free;
        int expectedModCount;
        int index;
        short curKey;

        NoRemovedCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.keys = UpdatableSeparateKVShortLHashGO.this.set;
            this.index = this.keys.length;
            this.curKey = free = (this.free = UpdatableSeparateKVShortLHashGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != UpdatableSeparateKVShortLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableSeparateKVShortLHashGO.this.modCount()) {
                short[] keys = this.keys;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    short key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements ShortIterator {
        final short[] keys;
        final short free;
        int expectedModCount;
        int nextIndex;
        short next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableSeparateKVShortLHashGO.this.set;
            short[] keys = UpdatableSeparateKVShortLHashGO.this.set;
            short free = this.free = UpdatableSeparateKVShortLHashGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableSeparateKVShortLHashGO.this.modCount()) {
                    short[] keys = this.keys;
                    short free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        short key = keys[nextI];
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept((Short)key);
            }
            if (nextI != this.nextIndex || mc != UpdatableSeparateKVShortLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            short[] keys = this.keys;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != UpdatableSeparateKVShortLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

