/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.Maths;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMarshaller
implements BytesMarshaller<Class> {
    private static final int CACHE_SIZE = 1019;
    private static final Map<String, Class> SC_SHORT_NAME;
    private static final Map<Class, String> CS_SHORT_NAME;
    private final ClassLoader classLoader;
    private final StringBuilder className = new StringBuilder(40);
    @Nullable
    private WeakReference<Class>[] classWeakReference = null;

    public ClassMarshaller(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Class aClass) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/ClassMarshaller.write must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of net/openhft/lang/io/impl/ClassMarshaller.write must not be null");
        }
        String s = CS_SHORT_NAME.get(aClass);
        if (s == null) {
            s = aClass.getName();
        }
        bytes.writeUTF\u0394(s);
    }

    @Override
    @Nullable
    public Class read(@NotNull Bytes bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/ClassMarshaller.read must not be null");
        }
        this.className.setLength(0);
        bytes.readUTF\u0394(this.className);
        return this.load(this.className);
    }

    @Nullable
    private Class load(@NotNull CharSequence name) {
        Class<?> clazz;
        WeakReference<Class> ref;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/ClassMarshaller.load must not be null");
        }
        int hash = (int)(Maths.hashOf(name) & 0x7FFFFFFL) % 1019;
        if (this.classWeakReference == null) {
            this.classWeakReference = new WeakReference[1019];
        }
        if ((ref = this.classWeakReference[hash]) != null && (clazz = (Class<?>)ref.get()) != null && clazz.getName().equals(name)) {
            return clazz;
        }
        try {
            clazz = SC_SHORT_NAME.get(name.toString());
            if (clazz != null) {
                return clazz;
            }
            clazz = this.classLoader.loadClass(name.toString());
            this.classWeakReference[hash] = new WeakReference(clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        Class[] classes;
        SC_SHORT_NAME = new LinkedHashMap<String, Class>();
        CS_SHORT_NAME = new LinkedHashMap<Class, String>();
        for (Class clazz : classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Class.class, BigInteger.class, BigDecimal.class, Date.class}) {
            String simpleName = clazz.getSimpleName();
            SC_SHORT_NAME.put(simpleName, clazz);
            CS_SHORT_NAME.put(clazz, simpleName);
        }
    }
}

