/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.io.Externalizable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.BytesMarshallable;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.io.BytesMarshallerFactory;
import net.openhft.lang.io.impl.BytesMarshallableMarshaller;
import net.openhft.lang.io.impl.ClassMarshaller;
import net.openhft.lang.io.impl.DateMarshaller;
import net.openhft.lang.io.impl.ExternalizableMarshaller;
import net.openhft.lang.io.impl.GenericEnumMarshaller;
import net.openhft.lang.io.impl.NoMarshaller;
import net.openhft.lang.io.impl.StringMarshaller;
import net.openhft.lang.io.impl.VanillaBytesMarshaller;
import org.jetbrains.annotations.NotNull;

public class VanillaBytesMarshallerFactory
implements BytesMarshallerFactory {
    private final Map<Class, BytesMarshaller> marshallerMap = new LinkedHashMap<Class, BytesMarshaller>();

    public VanillaBytesMarshallerFactory() {
        StringMarshaller stringMarshaller = new StringMarshaller(16384);
        this.marshallerMap.put(String.class, stringMarshaller);
        this.marshallerMap.put(CharSequence.class, stringMarshaller);
        this.marshallerMap.put(Class.class, new ClassMarshaller(Thread.currentThread().getContextClassLoader()));
        this.marshallerMap.put(Date.class, new DateMarshaller(10191));
    }

    @Override
    @NotNull
    public <E> BytesMarshaller<E> acquireMarshaller(@NotNull Class<E> eClass, boolean create) {
        if (eClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/io/impl/VanillaBytesMarshallerFactory.acquireMarshaller must not be null");
        }
        BytesMarshaller<Object> em = this.marshallerMap.get(eClass);
        if (em == null) {
            if (eClass.isEnum()) {
                em = new VanillaBytesMarshaller<Object>(eClass, null);
                this.marshallerMap.put(eClass, em);
            } else if (BytesMarshallable.class.isAssignableFrom(eClass)) {
                em = new BytesMarshallableMarshaller<E>(eClass);
                this.marshallerMap.put(eClass, em);
            } else if (Externalizable.class.isAssignableFrom(eClass)) {
                em = new ExternalizableMarshaller<E>(eClass);
                this.marshallerMap.put(eClass, em);
            } else {
                try {
                    em = new GenericEnumMarshaller<E>(eClass, 1000);
                    this.marshallerMap.put(eClass, em);
                }
                catch (Exception e) {
                    em = NoMarshaller.INSTANCE;
                    this.marshallerMap.put(eClass, em);
                }
            }
        }
        VanillaBytesMarshaller<Object> vanillaBytesMarshaller = em;
        if (vanillaBytesMarshaller == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/io/impl/VanillaBytesMarshallerFactory.acquireMarshaller must not return null");
        }
        return vanillaBytesMarshaller;
    }
}

