/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.pool;

import net.openhft.lang.Maths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringInterner {
    @NotNull
    private final String[] interner;
    private final int mask;

    public StringInterner(int capacity) {
        int n = Maths.nextPower2(capacity, 128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    private static boolean isEqual(@Nullable CharSequence s, @NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of net/openhft/lang/pool/StringInterner.isEqual must not be null");
        }
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String intern(@NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/lang/pool/StringInterner.intern must not be null");
        }
        long hash = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            hash = 57L * hash + (long)cs.charAt(i);
        }
        int h = Maths.hash(hash) & this.mask;
        String s = this.interner[h];
        if (StringInterner.isEqual(s, cs)) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException("@NotNull method net/openhft/lang/pool/StringInterner.intern must not return null");
            }
            return string;
        }
        String s2 = cs.toString();
        this.interner[h] = s2;
        if (this.interner[h] == null) {
            throw new IllegalStateException("@NotNull method net/openhft/lang/pool/StringInterner.intern must not return null");
        }
        return this.interner[h];
    }
}

