/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.Externalizable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.BytesMarshallableMarshaller;
import net.openhft.lang.io.serialization.impl.ClassMarshaller;
import net.openhft.lang.io.serialization.impl.DateMarshaller;
import net.openhft.lang.io.serialization.impl.ExternalizableMarshaller;
import net.openhft.lang.io.serialization.impl.GenericEnumMarshaller;
import net.openhft.lang.io.serialization.impl.NoMarshaller;
import net.openhft.lang.io.serialization.impl.StringMarshaller;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshaller;
import org.jetbrains.annotations.NotNull;

public class VanillaBytesMarshallerFactory
implements BytesMarshallerFactory {
    private final Map<Class, BytesMarshaller> marshallerMap = new LinkedHashMap<Class, BytesMarshaller>();

    public VanillaBytesMarshallerFactory() {
        StringMarshaller stringMarshaller = new StringMarshaller(16384);
        this.marshallerMap.put(String.class, stringMarshaller);
        this.marshallerMap.put(CharSequence.class, stringMarshaller);
        this.marshallerMap.put(Class.class, new ClassMarshaller(Thread.currentThread().getContextClassLoader()));
        this.marshallerMap.put(Date.class, new DateMarshaller(10191));
    }

    @Override
    @NotNull
    public <E> BytesMarshaller<E> acquireMarshaller(@NotNull Class<E> eClass, boolean create) {
        BytesMarshaller<Object> em = this.marshallerMap.get(eClass);
        if (em == null) {
            if (eClass.isEnum()) {
                em = new VanillaBytesMarshaller<Object>(eClass, null);
                this.marshallerMap.put(eClass, em);
            } else if (BytesMarshallable.class.isAssignableFrom(eClass)) {
                em = new BytesMarshallableMarshaller<E>(eClass);
                this.marshallerMap.put(eClass, em);
            } else if (Externalizable.class.isAssignableFrom(eClass)) {
                em = new ExternalizableMarshaller<E>(eClass);
                this.marshallerMap.put(eClass, em);
            } else {
                try {
                    em = new GenericEnumMarshaller<E>(eClass, 1000);
                    this.marshallerMap.put(eClass, em);
                }
                catch (Exception e) {
                    em = NoMarshaller.INSTANCE;
                    this.marshallerMap.put(eClass, em);
                }
            }
        }
        return em;
    }
}

