/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.io.BytesMarshallerFactory;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Cleaner;

public class DirectStore {
    protected final BytesMarshallerFactory bytesMarshallerFactory;
    private final Cleaner cleaner;
    protected long address;
    protected long size;

    public DirectStore(BytesMarshallerFactory bytesMarshallerFactory, long size) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        this.address = NativeBytes.UNSAFE.allocateMemory(size);
        NativeBytes.UNSAFE.setMemory(this.address, size, (byte)0);
        NativeBytes.UNSAFE.putLongVolatile(null, this.address, 0L);
        this.size = size;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (DirectStore.this.address > 0L) {
                    NativeBytes.UNSAFE.freeMemory(DirectStore.this.address);
                }
                DirectStore.this.size = 0L;
                DirectStore.this.address = 0L;
            }
        });
    }

    @Nullable
    public static DirectStore allocate(long size) {
        return new DirectStore(null, size);
    }

    public void resize(long newSize) {
        if (newSize == this.size) {
            return;
        }
        this.address = NativeBytes.UNSAFE.reallocateMemory(this.address, newSize);
        this.size = newSize;
    }

    @NotNull
    public DirectBytes createSlice() {
        return new DirectBytes(this);
    }

    public void free() {
        this.cleaner.clean();
    }

    public long size() {
        return this.size;
    }
}

