/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.io.StopCharTester;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMarshaller
implements BytesMarshaller<Class> {
    private static final int CACHE_SIZE = 1019;
    private static final Map<String, Class> SC_SHORT_NAME;
    private static final Map<Class, String> CS_SHORT_NAME;
    private final ClassLoader classLoader;
    private final StringBuilder className = new StringBuilder(40);
    @Nullable
    private WeakReference<Class>[] classWeakReference = null;

    public ClassMarshaller(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static int hashOf(CharSequence name) {
        if (name instanceof String) {
            return name.hashCode();
        }
        int h = 0;
        for (int i = 0; i < name.length(); ++i) {
            h = 31 * h + name.charAt(i);
        }
        return h;
    }

    @Override
    @NotNull
    public Class<Class> classMarshaled() {
        return Class.class;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Class aClass) {
        String s = CS_SHORT_NAME.get(aClass);
        if (s == null) {
            s = aClass.getName();
        }
        bytes.writeUTF\u0394(s);
    }

    @Override
    public void append(@NotNull Bytes bytes, @NotNull Class aClass) {
        String s = CS_SHORT_NAME.get(aClass);
        if (s == null) {
            s = aClass.getName();
        }
        bytes.append(s);
    }

    @Override
    @Nullable
    public Class read(@NotNull Bytes bytes) {
        this.className.setLength(0);
        bytes.readUTF\u0394(this.className);
        return this.load(this.className);
    }

    @Nullable
    private Class load(@NotNull CharSequence name) {
        Class<?> clazz;
        WeakReference<Class> ref;
        int hash = ClassMarshaller.hashOf(name) % 1019;
        if (this.classWeakReference == null) {
            this.classWeakReference = new WeakReference[1019];
        }
        if ((ref = this.classWeakReference[hash]) != null && (clazz = (Class<?>)ref.get()) != null && clazz.getName().equals(name)) {
            return clazz;
        }
        try {
            clazz = SC_SHORT_NAME.get(name.toString());
            if (clazz != null) {
                return clazz;
            }
            clazz = this.classLoader.loadClass(name.toString());
            this.classWeakReference[hash] = new WeakReference(clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @Nullable
    public Class parse(@NotNull Bytes bytes, @NotNull StopCharTester tester) {
        this.className.setLength(0);
        bytes.parseUTF(this.className, tester);
        return this.load(this.className);
    }

    static {
        Class[] classes;
        SC_SHORT_NAME = new LinkedHashMap<String, Class>();
        CS_SHORT_NAME = new LinkedHashMap<Class, String>();
        for (Class clazz : classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Class.class, BigInteger.class, BigDecimal.class, Date.class}) {
            String simpleName = clazz.getSimpleName();
            SC_SHORT_NAME.put(simpleName, clazz);
            CS_SHORT_NAME.put(clazz, simpleName);
        }
    }
}

