/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.impl;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesMarshaller;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.pool.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringMarshaller
implements BytesMarshaller<String> {
    private final int size;
    private final StringBuilder reader = new StringBuilder();
    private StringInterner interner;

    public StringMarshaller(int size) {
        this.size = size;
    }

    @Override
    @NotNull
    public Class<String> classMarshaled() {
        return String.class;
    }

    @Override
    public void write(@NotNull Bytes bytes, String s) {
        bytes.writeUTF\u0394(s);
    }

    @Override
    public void append(@NotNull Bytes bytes, @NotNull String s) {
        bytes.append(s);
    }

    @Override
    @Nullable
    public String read(@NotNull Bytes bytes) {
        if (bytes.readUTF\u0394(this.reader)) {
            return this.builderToString();
        }
        return null;
    }

    @Override
    public String parse(@NotNull Bytes bytes, @NotNull StopCharTester tester) {
        this.reader.setLength(0);
        bytes.parseUTF(this.reader, tester);
        return this.builderToString();
    }

    private String builderToString() {
        if (this.interner == null) {
            this.interner = new StringInterner(this.size);
        }
        return this.interner.intern(this.reader);
    }
}

