/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.direct;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.direct.DirectSerializationMetadata;

public final class ObjectMarshaller<T> {
    private final DirectSerializationMetadata.SerializationMetadata metadata;

    public ObjectMarshaller(DirectSerializationMetadata.SerializationMetadata metadata) {
        this.metadata = metadata;
    }

    public void write(Bytes bytes, T tObject) {
        long i;
        long end = this.metadata.start + this.metadata.length;
        for (i = this.metadata.start; i < end - 7L; i += 8L) {
            bytes.writeLong(NativeBytes.UNSAFE.getLong(tObject, i));
        }
        while (i < end) {
            bytes.writeByte(NativeBytes.UNSAFE.getByte(tObject, i));
            ++i;
        }
    }

    public T read(Bytes bytes, T tObject) {
        long i;
        long end = this.metadata.start + this.metadata.length;
        for (i = this.metadata.start; i < end - 7L; i += 8L) {
            NativeBytes.UNSAFE.putLong(tObject, i, bytes.readLong());
        }
        while (i < end) {
            NativeBytes.UNSAFE.putByte(tObject, i, bytes.readByte());
            ++i;
        }
        return tObject;
    }

    public long length() {
        return this.metadata.length;
    }
}

