/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.direct;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.lang.io.serialization.direct.DirectSerializationFilter;
import net.openhft.lang.io.serialization.direct.DirectSerializationMetadata;
import net.openhft.lang.io.serialization.direct.Introspect;
import net.openhft.lang.io.serialization.direct.ObjectMarshaller;

public final class ObjectMarshallers {
    private static final Logger Log = Logger.getLogger(ObjectMarshallers.class.getName());
    private static final Map<Class, ObjectMarshaller> metadata = new HashMap<Class, ObjectMarshaller>();

    public static <T> ObjectMarshaller<T> forClass(Class<T> clazz) {
        ObjectMarshaller om = metadata.get(clazz);
        if (om == null) {
            DirectSerializationMetadata.SerializationMetadata serializationMetadata;
            List<Field> eligibleFields;
            List<Field> fields = Introspect.fields(clazz);
            if (ObjectMarshallers.hasIneligibleFields(fields, eligibleFields = DirectSerializationFilter.stopAtFirstIneligibleField(fields))) {
                WarnAboutIneligibleFields.apply(clazz, fields, eligibleFields);
                serializationMetadata = DirectSerializationMetadata.extractMetadataForPartialCopy(eligibleFields);
            } else {
                serializationMetadata = DirectSerializationMetadata.extractMetadata(eligibleFields);
            }
            om = new ObjectMarshaller(serializationMetadata);
            Log.log(Level.WARNING, String.format("Class %s has metadata %s", clazz.getName(), serializationMetadata));
            metadata.put(clazz, om);
        }
        return om;
    }

    private static boolean hasIneligibleFields(List<Field> allFields, List<Field> eligibleFields) {
        return allFields.size() != eligibleFields.size();
    }

    private static class WarnAboutIneligibleFields {
        private WarnAboutIneligibleFields() {
        }

        static void apply(Class clazz, List<Field> allFields, List<Field> eligibleFields) {
            List<Field> ineligibleFields = allFields.subList(eligibleFields.size(), allFields.size());
            Log.log(Level.WARNING, String.format("The following fields in Class %s will not be copied by ObjectMarshaller:\n%s", clazz.getName(), WarnAboutIneligibleFields.commaSeparate(ineligibleFields)));
        }

        private static String commaSeparate(Collection<Field> fields) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Field field : fields) {
                if (first) {
                    sb.append("\t");
                    sb.append(field.getName());
                    first = false;
                    continue;
                }
                sb.append("\n\t");
                sb.append(field.getName());
            }
            return sb.toString();
        }
    }
}

