/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang;

public enum Assert {


    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        Assert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null ? actual != null : !expected.equals(actual)) {
            if (expected instanceof String && actual instanceof String) {
                String cleanMessage = message == null ? "" : message;
                throw new ComparisonFailure(cleanMessage, (String)expected, (String)actual);
            }
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Double.compare(expected, actual) != 0 && Math.abs(expected - actual) > delta) {
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Float.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(message, Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    private static boolean doubleIsDifferent(double d1, double d2, double delta) {
        return Double.compare(d1, d2) != 0 && Math.abs(d1 - d2) > delta;
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, long expected, long actual) {
        if (expected != actual) {
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertTrue(message, object != null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        if (object == null) {
            return;
        }
        Assert.failNotNull(message, object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    private static void failNotNull(String message, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + ' ';
        }
        Assert.fail(formatted + "expected null, but was:<" + actual + '>');
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            Assert.failSame(message);
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assert.assertNotSame(null, unexpected, actual);
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + ' ';
        }
        Assert.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + ' ';
        }
        Assert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + '>');
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        Assert.fail(Assert.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.isEmpty()) {
            formatted = message + ' ';
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + Assert.formatClassAndValue(expected, expectedString) + " but was: " + Assert.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + '>';
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + '<' + valueString + '>';
    }

    public static class ComparisonFailure
    extends AssertionError {
        private static final int MAX_CONTEXT_LENGTH = 20;
        private final String fExpected;
        private final String fActual;

        public ComparisonFailure(String message, String expected, String actual) {
            super((Object)message);
            this.fExpected = expected;
            this.fActual = actual;
        }

        public String getMessage() {
            return new ComparisonCompactor(20, this.fExpected, this.fActual).compact(super.getMessage());
        }

        public String getActual() {
            return this.fActual;
        }

        public String getExpected() {
            return this.fExpected;
        }

        private static class ComparisonCompactor {
            private static final String ELLIPSIS = "...";
            private static final String DELTA_END = "]";
            private static final String DELTA_START = "[";
            private final int fContextLength;
            private final String fExpected;
            private final String fActual;
            private int fPrefix;
            private int fSuffix;

            public ComparisonCompactor(int contextLength, String expected, String actual) {
                this.fContextLength = contextLength;
                this.fExpected = expected;
                this.fActual = actual;
            }

            private String compact(String message) {
                if (this.fExpected == null || this.fActual == null || this.areStringsEqual()) {
                    return Assert.format(message, this.fExpected, this.fActual);
                }
                this.findCommonPrefix();
                this.findCommonSuffix();
                String expected = this.compactString(this.fExpected);
                String actual = this.compactString(this.fActual);
                return Assert.format(message, expected, actual);
            }

            private String compactString(String source) {
                String result = DELTA_START + source.substring(this.fPrefix, source.length() - this.fSuffix + 1) + DELTA_END;
                if (this.fPrefix > 0) {
                    result = this.computeCommonPrefix() + result;
                }
                if (this.fSuffix > 0) {
                    result = result + this.computeCommonSuffix();
                }
                return result;
            }

            private void findCommonPrefix() {
                this.fPrefix = 0;
                int end = Math.min(this.fExpected.length(), this.fActual.length());
                while (this.fPrefix < end && this.fExpected.charAt(this.fPrefix) == this.fActual.charAt(this.fPrefix)) {
                    ++this.fPrefix;
                }
            }

            private void findCommonSuffix() {
                int expectedSuffix = this.fExpected.length() - 1;
                for (int actualSuffix = this.fActual.length() - 1; actualSuffix >= this.fPrefix && expectedSuffix >= this.fPrefix && this.fExpected.charAt(expectedSuffix) == this.fActual.charAt(actualSuffix); --actualSuffix, --expectedSuffix) {
                }
                this.fSuffix = this.fExpected.length() - expectedSuffix;
            }

            private String computeCommonPrefix() {
                return (this.fPrefix > this.fContextLength ? ELLIPSIS : "") + this.fExpected.substring(Math.max(0, this.fPrefix - this.fContextLength), this.fPrefix);
            }

            private String computeCommonSuffix() {
                int end = Math.min(this.fExpected.length() - this.fSuffix + 1 + this.fContextLength, this.fExpected.length());
                return this.fExpected.substring(this.fExpected.length() - this.fSuffix + 1, end) + (this.fExpected.length() - this.fSuffix + 1 < this.fExpected.length() - this.fContextLength ? ELLIPSIS : "");
            }

            private boolean areStringsEqual() {
                return this.fExpected.equals(this.fActual);
            }
        }
    }
}

