/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection.impl;

import java.util.ArrayList;
import java.util.List;
import net.openhft.lang.collection.HugeArray;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.DataValueClasses;

public class HugeArrayImpl<T>
implements HugeArray<T> {
    private static final int MAX_SIZE = 10;
    private final Class<T> tClass;
    private final long length;
    private final int size;
    private final DirectStore store;
    private final List<T> freeList = new ArrayList<T>(10);

    public HugeArrayImpl(Class<T> tClass, long length) {
        this.tClass = tClass;
        this.length = length;
        T ref = DataValueClasses.newDirectReference(tClass);
        this.size = ((Byteable)ref).maxSize();
        this.store = new DirectStore(null, length * (long)this.size);
        ((Byteable)ref).bytes(this.store.createSlice(), 0L);
        this.recycle(ref);
    }

    private T createRef() {
        T ref = DataValueClasses.newInstance(this.tClass);
        ((Byteable)ref).bytes(this.store.createSlice(), 0L);
        return ref;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public T get(long index) {
        T t = this.acquire();
        Byteable byteable = (Byteable)t;
        DirectBytes bytes = (DirectBytes)byteable.bytes();
        bytes.positionAndSize(index * (long)this.size, this.size);
        return t;
    }

    @Override
    public void get(long index, T element) {
        if (this.tClass.isInstance(element)) {
            DirectBytes bytes = (DirectBytes)((Byteable)element).bytes();
            bytes.positionAndSize(index * (long)this.size, this.size);
            return;
        }
        T t = this.acquire();
        DirectBytes bytes = (DirectBytes)((Byteable)t).bytes();
        bytes.positionAndSize(index * (long)this.size, this.size);
        ((Copyable)element).copyFrom(t);
        this.recycle(t);
    }

    private T acquire() {
        int size = this.freeList.size();
        if (size > 0) {
            return this.freeList.remove(size - 1);
        }
        return this.createRef();
    }

    @Override
    public void copyTo(long index, T to) {
        T from = this.get(index);
        ((Copyable)to).copyFrom(from);
        this.recycle(from);
    }

    @Override
    public void set(long index, T from) {
        T to = this.get(index);
        ((Copyable)to).copyFrom(from);
        this.recycle(to);
    }

    @Override
    public void recycle(T t) {
        if (this.freeList.size() < 10) {
            assert (((DirectBytes)((Byteable)t).bytes()).store() == this.store);
            assert (!this.freeList.contains(t)) : "recycling object already recycled";
            this.freeList.add(t);
        }
    }
}

