/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.pool;

import net.openhft.lang.Maths;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class StringInterner {
    @NotNull
    private final String[] interner;
    private final int mask;

    public StringInterner(int capacity) {
        int n = Maths.nextPower2(capacity, 128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    private static boolean isEqual(@Nullable CharSequence s, @NotNull CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String intern(@NotNull CharSequence cs) {
        String s2;
        long hash = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            hash = 57L * hash + (long)cs.charAt(i);
        }
        int h = Maths.hash(hash) & this.mask;
        String s = this.interner[h];
        if (StringInterner.isEqual(s, cs)) {
            return s;
        }
        this.interner[h] = s2 = ((Object)cs).toString();
        return this.interner[h];
    }
}

