/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaMappedCache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VanillaMappedCache.class);
    private final Map<T, DataHolder> cache;

    public VanillaMappedCache() {
        this(new LinkedHashMap());
    }

    public VanillaMappedCache(final int maximumCacheSize, final boolean cleanOnRemove) {
        this(new LinkedHashMap<T, DataHolder>(maximumCacheSize, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, DataHolder> eldest) {
                boolean removed;
                boolean bl = removed = this.size() >= maximumCacheSize;
                if (removed && cleanOnRemove) {
                    eldest.getValue().close();
                }
                return removed;
            }
        });
    }

    private VanillaMappedCache(Map<T, DataHolder> cache) {
        this.cache = cache;
    }

    public VanillaMappedBytes get(T key) {
        DataHolder data = this.cache.get(key);
        return data != null ? data.bytes() : null;
    }

    public VanillaMappedBytes put(T key, File path, long size) {
        return this.put(key, path, size, -1L);
    }

    public VanillaMappedBytes put(T key, File path, long size, long index) {
        DataHolder data = this.cache.get(key);
        if (data != null) {
            data.close();
        } else {
            data = new DataHolder();
        }
        try {
            this.cleanup();
            data.recycle(VanillaMappedFile.readWrite(path, size), 0L, size, index);
            this.cache.put(key, data);
        }
        catch (IOException e) {
            LOGGER.warn("", (Throwable)e);
        }
        return data.bytes();
    }

    public int size() {
        return this.cache.size();
    }

    public void close() {
        this.cleanup();
    }

    public synchronized void checkCounts(int min, int max) {
        for (DataHolder data : this.cache.values()) {
            if (data.bytes().refCount() >= min && data.bytes().refCount() <= max) continue;
            throw new IllegalStateException(data.file().path() + " has a count of " + data.bytes().refCount());
        }
    }

    private void cleanup() {
        Iterator<Map.Entry<T, DataHolder>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, DataHolder> entry = it.next();
            if (!entry.getValue().bytes().unmapped()) continue;
            entry.getValue().close();
            it.remove();
        }
    }

    private class DataHolder {
        private VanillaMappedFile file;
        private VanillaMappedBytes bytes;

        public DataHolder() {
            this(null, null);
        }

        public DataHolder(VanillaMappedFile file, VanillaMappedBytes bytes) {
            this.file = file;
            this.bytes = bytes;
        }

        public VanillaMappedFile file() {
            return this.file;
        }

        public VanillaMappedBytes bytes() {
            return this.bytes;
        }

        public void recycle(VanillaMappedFile file, VanillaMappedBytes bytes) {
            this.close();
            this.file = file;
            this.bytes = bytes;
        }

        public void recycle(VanillaMappedFile file, long address, long size) throws IOException {
            this.recycle(file, file.bytes(address, size));
        }

        public void recycle(VanillaMappedFile file, long address, long size, long index) throws IOException {
            this.recycle(file, file.bytes(address, size, index));
        }

        public void close() {
            try {
                if (this.bytes != null) {
                    this.bytes.release();
                    if (this.file != null && this.bytes.unmapped()) {
                        this.file.close();
                        this.bytes = null;
                        this.file = null;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("", (Throwable)e);
            }
        }
    }
}

