/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public enum StringZMarshaller implements CompactBytesMarshaller<String>
{
    INSTANCE;

    private static final int NULL_LENGTH = -1;

    @Override
    public byte code() {
        return 26;
    }

    @Override
    public void write(Bytes bytes, String s) {
        if (s == null) {
            bytes.writeStopBit(-1L);
            return;
        }
        bytes.writeStopBit(s.length());
        long position = bytes.position();
        bytes.clear();
        bytes.position(position + 4L);
        DataOutputStream dos = new DataOutputStream(new DeflaterOutputStream(bytes.outputStream()));
        try {
            dos.writeUTF(s);
            dos.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.writeUnsignedInt(position, bytes.position() - position - 4L);
    }

    @Override
    public String read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public String read(Bytes bytes, @Nullable String ignored) {
        String s;
        long size = bytes.readStopBit();
        if (size == -1L) {
            return null;
        }
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + size);
        }
        long length = bytes.readUnsignedInt();
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + length);
        }
        long position = bytes.position();
        long end = position + length;
        long limit = bytes.limit();
        bytes.limit(end);
        DataInputStream dis = new DataInputStream(new InflaterInputStream(bytes.inputStream()));
        try {
            s = dis.readUTF();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.position(end);
        bytes.limit(limit);
        return s;
    }
}

