/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class GenericEnumMarshaller<E>
implements BytesMarshaller<E> {
    @Nullable
    private final Constructor<E> constructor;
    @Nullable
    private final Method valueOf;
    @NotNull
    private final Map<String, E> map;

    public GenericEnumMarshaller(@NotNull Class<E> classMarshaled, final int capacity) {
        Constructor<E> constructor = null;
        Method valueOf = null;
        try {
            valueOf = classMarshaled.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = classMarshaled.getConstructor(String.class);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException(classMarshaled + " doesn't have a valueOf(String) or a Constructor(String)");
            }
        }
        this.constructor = constructor;
        this.valueOf = valueOf;
        this.map = new LinkedHashMap<String, E>(128, 0.7f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, E> eldest) {
                return this.size() > capacity;
            }
        };
    }

    @Override
    public void write(@NotNull Bytes bytes, @Nullable E e) {
        bytes.writeUTF\u0394(e == null ? null : e.toString());
    }

    @Override
    @Nullable
    public E read(@NotNull Bytes bytes) {
        String s = bytes.readUTF\u0394();
        return s == null ? null : (E)this.valueOf(s);
    }

    @Override
    @Nullable
    public E read(Bytes bytes, @Nullable E e) {
        return this.read(bytes);
    }

    private E valueOf(String s) {
        Object e = this.map.get(s);
        if (e == null) {
            try {
                if (this.constructor != null) {
                    e = this.constructor.newInstance(s);
                    this.map.put(s, e);
                } else {
                    Object invoke = this.valueOf.invoke(null, s);
                    e = invoke;
                    this.map.put(s, e);
                }
            }
            catch (Exception t) {
                throw new AssertionError((Object)t);
            }
        }
        return e;
    }
}

