/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.thread;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.openhft.lang.thread.Pauser;

public class LightPauser
implements Pauser {
    private final AtomicBoolean pausing = new AtomicBoolean();
    private final int busyCount;
    private final long parkPeriod;
    private int count;
    private volatile Thread thread;

    public LightPauser(int busyCount, long parkPeriod) {
        this.busyCount = busyCount;
        this.parkPeriod = parkPeriod;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void pause() {
        if (this.count++ < this.busyCount) {
            return;
        }
        this.thread = Thread.currentThread();
        this.pausing.set(true);
        LockSupport.parkNanos(this.parkPeriod);
        this.pausing.set(false);
        this.reset();
    }

    @Override
    public void unpause() {
        if (this.pausing.get()) {
            LockSupport.unpark(this.thread);
        }
    }
}

