/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization;

import java.io.Externalizable;
import java.io.IOException;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.NoMarshaller;
import org.jetbrains.annotations.NotNull;

public class BytesMarshallableSerializer
implements ObjectSerializer {
    private static final byte NULL = 78;
    private static final byte ENUMED = 69;
    private static final byte SERIALIZED = 83;
    private final BytesMarshallerFactory bytesMarshallerFactory;
    private final ObjectSerializer objectSerializer;

    protected BytesMarshallableSerializer(BytesMarshallerFactory bytesMarshallerFactory, ObjectSerializer objectSerializer) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        this.objectSerializer = objectSerializer;
    }

    @Override
    public void writeSerializable(Bytes bytes, Object object, Class expectedClass) throws IOException {
        Class<?> clazz;
        BytesMarshaller<?> em;
        if (object == null) {
            bytes.writeByte(78);
            return;
        }
        if (expectedClass != null) {
            if (BytesMarshallable.class.isAssignableFrom(expectedClass)) {
                ((BytesMarshallable)object).writeMarshallable(bytes);
                return;
            }
            if (Externalizable.class.isAssignableFrom(expectedClass)) {
                ((Externalizable)object).writeExternal(bytes);
                return;
            }
            if (CharSequence.class.isAssignableFrom(expectedClass)) {
                bytes.writeUTF\u0394((CharSequence)object);
                return;
            }
        }
        if ((em = this.bytesMarshallerFactory.acquireMarshaller(clazz = object.getClass(), false)) == NoMarshaller.INSTANCE && BytesMarshallableSerializer.autoGenerateMarshaller(object)) {
            em = this.bytesMarshallerFactory.acquireMarshaller(clazz, true);
        }
        if (em != NoMarshaller.INSTANCE) {
            if (em instanceof CompactBytesMarshaller) {
                bytes.writeByte(((CompactBytesMarshaller)em).code());
                em.write(bytes, object);
                return;
            }
            bytes.writeByte(69);
            bytes.writeEnum(clazz);
            em.write(bytes, object);
            return;
        }
        bytes.writeByte(83);
        this.objectSerializer.writeSerializable(bytes, object, null);
    }

    static boolean autoGenerateMarshaller(Object obj) {
        return obj instanceof Comparable && obj.getClass().getPackage().getName().startsWith("java") || obj instanceof Externalizable || obj instanceof BytesMarshallable;
    }

    @Override
    public <T> T readSerializable(@NotNull Bytes bytes, Class<T> expectedClass, T object) throws IOException, ClassNotFoundException {
        if (expectedClass != null) {
            try {
                if (BytesMarshallable.class.isAssignableFrom(expectedClass)) {
                    return this.readBytesMarshallable(bytes, expectedClass, object);
                }
                if (Externalizable.class.isAssignableFrom(expectedClass)) {
                    return this.readExternalizable(bytes, expectedClass, object);
                }
                if (CharSequence.class.isAssignableFrom(expectedClass)) {
                    return this.readCharSequence(bytes, object);
                }
            }
            catch (InstantiationException e) {
                throw new IOException("Unable to create " + expectedClass, e);
            }
        }
        int type = bytes.readUnsignedByteOrThrow();
        switch (type) {
            case -1: 
            case 78: {
                return null;
            }
            case 69: {
                Class clazz = bytes.readEnum(Class.class);
                assert (clazz != null);
                return (T)this.bytesMarshallerFactory.acquireMarshaller(clazz, true).read(bytes);
            }
            case 83: {
                return this.objectSerializer.readSerializable(bytes, expectedClass, object);
            }
        }
        BytesMarshaller m = this.bytesMarshallerFactory.getMarshaller((byte)type);
        if (m == null) {
            throw new IllegalStateException("Unknown type " + (char)type);
        }
        return (T)m.read(bytes);
    }

    private <T> T readCharSequence(Bytes bytes, T object) {
        if (object instanceof StringBuilder) {
            bytes.readUTF\u0394((StringBuilder)object);
            return object;
        }
        return (T)bytes.readUTF\u0394();
    }

    private <T> T readExternalizable(Bytes bytes, Class<T> expectedClass, T object) throws InstantiationException, IOException, ClassNotFoundException {
        if (object == null) {
            object = NativeBytes.UNSAFE.allocateInstance(expectedClass);
        }
        ((Externalizable)object).readExternal(bytes);
        return object;
    }

    private <T> T readBytesMarshallable(Bytes bytes, Class<T> expectedClass, T object) throws InstantiationException {
        if (object == null) {
            object = NativeBytes.UNSAFE.allocateInstance(expectedClass);
        }
        ((BytesMarshallable)object).readMarshallable(bytes);
        return object;
    }

    public static ObjectSerializer create(BytesMarshallerFactory bytesMarshallerFactory, ObjectSerializer instance) {
        return bytesMarshallerFactory == null ? instance : new BytesMarshallableSerializer(bytesMarshallerFactory, instance);
    }
}

