/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.view;

import java.io.InputStream;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

public class BytesInputStream
extends InputStream {
    private Bytes bytes;
    private long mark = 0L;

    public BytesInputStream(Bytes bytes) {
        this.bytes = bytes;
    }

    public BytesInputStream() {
    }

    public BytesInputStream bytes(Bytes bytes) {
        this.bytes = bytes;
        this.mark = 0L;
        return this;
    }

    @Override
    public int available() {
        return this.bytes.available();
    }

    @Override
    public void close() {
        this.bytes.finish();
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.bytes.position();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.bytes.read(b, off, len);
    }

    @Override
    public void reset() {
        this.bytes.position(this.mark);
    }

    @Override
    public long skip(long n) {
        return this.bytes.skip(n);
    }

    @Override
    public int read() {
        return this.bytes.read();
    }
}

