/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.MutableDecimal;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.io.serialization.ObjectSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckedBytes
implements Bytes {
    private final Bytes bytes;
    volatile boolean isClosed = false;

    public CheckedBytes(Bytes bytes) {
        this.checkNotClosed();
        this.bytes = bytes;
    }

    @Override
    public void clearThreadAssociation() {
        this.checkNotClosed();
        this.bytes.clearThreadAssociation();
    }

    @Override
    public long size() {
        this.checkNotClosed();
        return this.bytes.size();
    }

    void checkNotClosed() {
        if (this.isClosed) {
            ThreadInfo[] threads;
            System.err.print("Thread " + Thread.currentThread().getName() + " performing processing " + "after free()");
            for (ThreadInfo info : threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                System.out.print(info);
            }
            System.exit(-1);
        }
    }

    @Override
    public void free() {
        this.isClosed = true;
        this.bytes.free();
    }

    @Override
    public void reserve() {
        this.checkNotClosed();
        this.bytes.reserve();
    }

    @Override
    public void release() {
        this.checkNotClosed();
        this.bytes.release();
    }

    @Override
    public int refCount() {
        this.checkNotClosed();
        return this.bytes.refCount();
    }

    @Override
    public void selfTerminating(boolean selfTerminating) {
        this.checkNotClosed();
        this.bytes.selfTerminating(selfTerminating);
    }

    @Override
    public boolean selfTerminating() {
        this.checkNotClosed();
        return this.bytes.selfTerminating();
    }

    @Override
    public int readUnsignedByteOrThrow() throws BufferUnderflowException {
        return this.bytes.readUnsignedByteOrThrow();
    }

    @Override
    public void write(long offset, Bytes bytes) {
        bytes.write(offset, bytes);
    }

    @Override
    public Boolean parseBoolean(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.bytes.parseBoolean(tester);
    }

    @Override
    public void readFully(@NotNull byte[] bytes) {
        this.checkNotClosed();
        this.bytes.readFully(bytes);
    }

    @Override
    public void readFully(@NotNull char[] data) {
        this.checkNotClosed();
        this.bytes.readFully(data);
    }

    @Override
    public int skipBytes(int n) {
        this.checkNotClosed();
        return this.bytes.skipBytes(n);
    }

    @Override
    public boolean readBoolean() {
        this.checkNotClosed();
        return this.bytes.readBoolean();
    }

    @Override
    public boolean readBoolean(long offset) {
        this.checkNotClosed();
        return this.bytes.readBoolean(offset);
    }

    @Override
    public int readUnsignedByte() {
        this.checkNotClosed();
        return this.bytes.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte(long offset) {
        this.checkNotClosed();
        return this.bytes.readUnsignedByte(offset);
    }

    @Override
    public int readUnsignedShort() {
        this.checkNotClosed();
        return this.bytes.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort(long offset) {
        this.checkNotClosed();
        return this.bytes.readUnsignedShort(offset);
    }

    @Override
    @NotNull
    public String readLine() {
        this.checkNotClosed();
        return this.bytes.readLine();
    }

    @Override
    @Nullable
    public String readUTF\u0394() {
        this.checkNotClosed();
        return this.bytes.readUTF\u0394();
    }

    @Override
    @Nullable
    public String readUTF\u0394(long offset) throws IllegalStateException {
        return this.bytes.readUTF\u0394(offset);
    }

    @Override
    public boolean readUTF\u0394(@NotNull StringBuilder stringBuilder) {
        this.checkNotClosed();
        return this.bytes.readUTF\u0394(stringBuilder);
    }

    @Override
    @NotNull
    public String parseUTF(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.bytes.parseUTF(tester);
    }

    @Override
    public void parseUTF(@NotNull StringBuilder builder, @NotNull StopCharTester tester) {
        this.checkNotClosed();
        this.bytes.parseUTF(builder, tester);
    }

    @Override
    public boolean stepBackAndSkipTo(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.bytes.stepBackAndSkipTo(tester);
    }

    @Override
    public boolean skipTo(@NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.bytes.skipTo(tester);
    }

    @Override
    @NotNull
    public String readUTF() {
        this.checkNotClosed();
        return this.bytes.readUTF();
    }

    @Override
    public short readCompactShort() {
        this.checkNotClosed();
        return this.bytes.readCompactShort();
    }

    @Override
    public int readCompactUnsignedShort() {
        this.checkNotClosed();
        return this.bytes.readCompactUnsignedShort();
    }

    @Override
    public int readInt24() {
        this.checkNotClosed();
        return this.bytes.readInt24();
    }

    @Override
    public int readInt24(long offset) {
        this.checkNotClosed();
        return this.bytes.readInt24(offset);
    }

    @Override
    public long readUnsignedInt() {
        this.checkNotClosed();
        return this.bytes.readUnsignedInt();
    }

    @Override
    public long readUnsignedInt(long offset) {
        this.checkNotClosed();
        return this.bytes.readUnsignedInt(offset);
    }

    @Override
    public int readCompactInt() {
        this.checkNotClosed();
        return this.bytes.readCompactInt();
    }

    @Override
    public long readCompactUnsignedInt() {
        this.checkNotClosed();
        return this.bytes.readCompactUnsignedInt();
    }

    @Override
    public long readInt48() {
        this.checkNotClosed();
        return this.bytes.readInt48();
    }

    @Override
    public long readInt48(long offset) {
        this.checkNotClosed();
        return this.bytes.readInt48(offset);
    }

    @Override
    public long readCompactLong() {
        this.checkNotClosed();
        return this.bytes.readCompactLong();
    }

    @Override
    public long readStopBit() {
        this.checkNotClosed();
        return this.bytes.readStopBit();
    }

    @Override
    public double readCompactDouble() {
        this.checkNotClosed();
        return this.bytes.readCompactDouble();
    }

    @Override
    public void read(@NotNull ByteBuffer bb) {
        this.checkNotClosed();
        this.bytes.read(bb);
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        this.checkNotClosed();
        this.bytes.write(bytes);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.checkNotClosed();
        this.bytes.writeBoolean(v);
    }

    @Override
    public void writeBoolean(long offset, boolean v) {
        this.checkNotClosed();
        this.bytes.writeBoolean(offset, v);
    }

    @Override
    public void writeBytes(@NotNull String s) {
        this.checkNotClosed();
        this.bytes.writeBytes(s);
    }

    @Override
    public void writeChars(@NotNull String s) {
        this.checkNotClosed();
        this.bytes.writeChars(s);
    }

    @Override
    public void writeChars(@NotNull CharSequence cs) {
        this.checkNotClosed();
        this.bytes.writeChars(cs);
    }

    @Override
    public void writeUTF(@NotNull String str) {
        this.checkNotClosed();
        this.bytes.writeUTF(str);
    }

    @Override
    public void writeUTF\u0394(@Nullable CharSequence str) throws IllegalArgumentException {
        this.bytes.writeUTF\u0394(str);
    }

    @Override
    public void writeUTF\u0394(long offset, int maxSize, @Nullable CharSequence s) throws IllegalStateException {
        this.bytes.writeUTF\u0394(offset, maxSize, s);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence str) {
        this.checkNotClosed();
        return this.bytes.append(str);
    }

    @Override
    public void writeByte(int v) {
        this.checkNotClosed();
        this.bytes.writeByte(v);
    }

    @Override
    public void writeUnsignedByte(int v) {
        this.checkNotClosed();
        this.bytes.writeUnsignedByte(v);
    }

    @Override
    public void writeUnsignedByte(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeUnsignedByte(offset, v);
    }

    @Override
    public void write(@NotNull char[] data) {
        this.checkNotClosed();
        this.bytes.write(data);
    }

    @Override
    public void write(@NotNull char[] data, int off, int len) {
        this.checkNotClosed();
        this.bytes.write(data, off, len);
    }

    @Override
    public void writeUnsignedShort(int v) {
        this.checkNotClosed();
        this.bytes.writeUnsignedShort(v);
    }

    @Override
    public void writeUnsignedShort(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeUnsignedShort(offset, v);
    }

    @Override
    public void writeCompactShort(int v) {
        this.checkNotClosed();
        this.bytes.writeCompactShort(v);
    }

    @Override
    public void writeCompactUnsignedShort(int v) {
        this.checkNotClosed();
        this.bytes.writeCompactUnsignedShort(v);
    }

    @Override
    public void writeInt24(int v) {
        this.checkNotClosed();
        this.bytes.writeInt24(v);
    }

    @Override
    public void writeInt24(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeInt24(offset, v);
    }

    @Override
    public void writeUnsignedInt(long v) {
        this.checkNotClosed();
        this.bytes.writeUnsignedInt(v);
    }

    @Override
    public void writeUnsignedInt(long offset, long v) {
        this.checkNotClosed();
        this.bytes.writeUnsignedInt(offset, v);
    }

    @Override
    public void writeCompactInt(int v) {
        this.checkNotClosed();
        this.bytes.writeCompactInt(v);
    }

    @Override
    public void writeCompactUnsignedInt(long v) {
        this.checkNotClosed();
        this.bytes.writeCompactUnsignedInt(v);
    }

    @Override
    public void writeInt48(long v) {
        this.checkNotClosed();
        this.bytes.writeInt48(v);
    }

    @Override
    public void writeInt48(long offset, long v) {
        this.checkNotClosed();
        this.bytes.writeInt48(offset, v);
    }

    @Override
    public void writeCompactLong(long v) {
        this.checkNotClosed();
        this.bytes.writeCompactLong(v);
    }

    @Override
    public void writeStopBit(long n) {
        this.checkNotClosed();
        this.bytes.writeStopBit(n);
    }

    @Override
    public void writeCompactDouble(double v) {
        this.checkNotClosed();
        this.bytes.writeCompactDouble(v);
    }

    @Override
    public void write(@NotNull ByteBuffer bb) {
        this.checkNotClosed();
        this.bytes.write(bb);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence s, int start, int end) {
        this.checkNotClosed();
        return this.bytes.append(s, start, end);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@Nullable Enum value) {
        this.checkNotClosed();
        return this.bytes.append(value);
    }

    @Override
    @NotNull
    public ByteStringAppender append(boolean b) {
        this.checkNotClosed();
        return this.bytes.append(b);
    }

    @Override
    @NotNull
    public ByteStringAppender append(char c) {
        this.checkNotClosed();
        return this.bytes.append(c);
    }

    @Override
    @NotNull
    public ByteStringAppender append(int num) {
        this.checkNotClosed();
        return this.bytes.append(num);
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num) {
        this.checkNotClosed();
        return this.bytes.append(num);
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num, int base) {
        this.checkNotClosed();
        return this.bytes.append(num, base);
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateMillis(long timeInMS) {
        this.checkNotClosed();
        return this.bytes.appendDateMillis(timeInMS);
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateTimeMillis(long timeInMS) {
        this.checkNotClosed();
        return this.bytes.appendDateTimeMillis(timeInMS);
    }

    @Override
    @NotNull
    public ByteStringAppender appendTimeMillis(long timeInMS) {
        this.checkNotClosed();
        return this.bytes.appendTimeMillis(timeInMS);
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d) {
        this.checkNotClosed();
        return this.bytes.append(d);
    }

    @Override
    public double parseDouble() {
        this.checkNotClosed();
        return this.bytes.parseDouble();
    }

    @Override
    @NotNull
    public <E> ByteStringAppender append(@NotNull Iterable<E> list, @NotNull CharSequence separator) {
        this.checkNotClosed();
        return this.bytes.append(list, separator);
    }

    @NotNull
    <E> ByteStringAppender append(@NotNull List<E> list, @NotNull CharSequence separator) {
        this.checkNotClosed();
        return this.bytes.append(list, separator);
    }

    @Override
    @NotNull
    public MutableDecimal parseDecimal(@NotNull MutableDecimal decimal) {
        this.checkNotClosed();
        return this.bytes.parseDecimal(decimal);
    }

    @Override
    public long parseLong() {
        this.checkNotClosed();
        return this.bytes.parseLong();
    }

    @Override
    public long parseLong(int base) {
        this.checkNotClosed();
        return this.bytes.parseLong(base);
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d, int precision) {
        this.checkNotClosed();
        return this.bytes.append(d, precision);
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull MutableDecimal md) {
        this.checkNotClosed();
        return this.bytes.append(md);
    }

    @Override
    @NotNull
    public InputStream inputStream() {
        this.checkNotClosed();
        return this.bytes.inputStream();
    }

    @Override
    @NotNull
    public OutputStream outputStream() {
        this.checkNotClosed();
        return this.bytes.outputStream();
    }

    @Override
    @NotNull
    public ObjectSerializer objectSerializer() {
        this.checkNotClosed();
        return this.bytes.objectSerializer();
    }

    @Override
    public <E> void writeEnum(@Nullable E e) {
        this.checkNotClosed();
        this.bytes.writeEnum(e);
    }

    @Override
    public <E> E readEnum(@NotNull Class<E> eClass) {
        this.checkNotClosed();
        return this.bytes.readEnum(eClass);
    }

    @Override
    public <E extends Enum<E>> E parseEnum(@NotNull Class<E> eClass, @NotNull StopCharTester tester) {
        this.checkNotClosed();
        return this.bytes.parseEnum(eClass, tester);
    }

    @Override
    public <E> void writeList(@NotNull Collection<E> list) {
        this.checkNotClosed();
        this.bytes.writeList(list);
    }

    @Override
    public <K, V> void writeMap(@NotNull Map<K, V> map) {
        this.checkNotClosed();
        this.bytes.writeMap(map);
    }

    @Override
    public <E> void readList(@NotNull Collection<E> list, @NotNull Class<E> eClass) {
        this.checkNotClosed();
        this.bytes.readList(list, eClass);
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> readMap(@NotNull Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass) {
        this.checkNotClosed();
        return this.bytes.readMap(map, kClass, vClass);
    }

    @Override
    public int available() {
        this.checkNotClosed();
        return this.bytes.available();
    }

    @Override
    public int read() {
        this.checkNotClosed();
        return this.bytes.read();
    }

    @Override
    public int read(@NotNull byte[] bytes) {
        this.checkNotClosed();
        return this.bytes.read(bytes);
    }

    @Override
    public long skip(long n) {
        this.checkNotClosed();
        return this.bytes.skip(n);
    }

    @Override
    public void close() {
        this.checkNotClosed();
        this.bytes.close();
    }

    @Override
    public void finish() throws IndexOutOfBoundsException {
        this.bytes.finish();
    }

    @Override
    public boolean isFinished() {
        this.checkNotClosed();
        return this.bytes.isFinished();
    }

    @Override
    public Bytes clear() {
        this.checkNotClosed();
        return this.bytes.clear();
    }

    @Override
    public Bytes flip() {
        this.checkNotClosed();
        return this.bytes.flip();
    }

    @Override
    public void flush() {
        this.checkNotClosed();
        this.bytes.flush();
    }

    @Override
    @Nullable
    public Object readObject() {
        this.checkNotClosed();
        return this.bytes.readObject();
    }

    @Override
    @Nullable
    public <T> T readObject(Class<T> tClass) throws IllegalStateException {
        return this.bytes.readObject(tClass);
    }

    @Override
    @Nullable
    public <T> T readInstance(@NotNull Class<T> objClass, T obj) {
        this.checkNotClosed();
        return this.bytes.readInstance(objClass, obj);
    }

    @Override
    public void writeObject(@Nullable Object obj) {
        this.checkNotClosed();
        this.bytes.writeObject(obj);
    }

    @Override
    public <OBJ> void writeInstance(@NotNull Class<OBJ> objClass, @NotNull OBJ obj) {
        this.checkNotClosed();
        this.bytes.writeInstance(objClass, obj);
    }

    @Override
    public boolean tryLockInt(long offset) {
        this.checkNotClosed();
        return this.bytes.tryLockInt(offset);
    }

    @Override
    public boolean tryLockNanosInt(long offset, long nanos) {
        this.checkNotClosed();
        return this.bytes.tryLockNanosInt(offset, nanos);
    }

    @Override
    public void busyLockInt(long offset) throws InterruptedException, IllegalStateException {
        this.bytes.busyLockInt(offset);
    }

    @Override
    public void unlockInt(long offset) throws IllegalMonitorStateException {
        this.bytes.unlockInt(offset);
    }

    @Override
    public void resetLockInt(long offset) {
        this.checkNotClosed();
        this.bytes.resetLockInt(offset);
    }

    @Override
    public int threadIdForLockInt(long offset) {
        this.checkNotClosed();
        return this.bytes.threadIdForLockInt(offset);
    }

    @Override
    public boolean tryLockLong(long offset) {
        this.checkNotClosed();
        return this.bytes.tryLockLong(offset);
    }

    @Override
    public boolean tryLockNanosLong(long offset, long nanos) {
        this.checkNotClosed();
        return this.bytes.tryLockNanosLong(offset, nanos);
    }

    @Override
    public void busyLockLong(long offset) throws InterruptedException, IllegalStateException {
        this.bytes.busyLockLong(offset);
    }

    @Override
    public void unlockLong(long offset) throws IllegalMonitorStateException {
        this.bytes.unlockLong(offset);
    }

    @Override
    public void resetLockLong(long offset) {
        this.checkNotClosed();
        this.bytes.resetLockLong(offset);
    }

    @Override
    public long threadIdForLockLong(long offset) {
        this.checkNotClosed();
        return this.bytes.threadIdForLockLong(offset);
    }

    @Override
    public int getAndAdd(long offset, int delta) {
        this.checkNotClosed();
        return this.bytes.getAndAdd(offset, delta);
    }

    @Override
    public int addAndGetInt(long offset, int delta) {
        this.checkNotClosed();
        return this.bytes.addAndGetInt(offset, delta);
    }

    @Override
    public byte addByte(long offset, byte b) {
        this.checkNotClosed();
        return this.bytes.addByte(offset, b);
    }

    @Override
    public int addUnsignedByte(long offset, int i) {
        this.checkNotClosed();
        return this.bytes.addUnsignedByte(offset, i);
    }

    @Override
    public short addShort(long offset, short s) {
        this.checkNotClosed();
        return this.bytes.addShort(offset, s);
    }

    @Override
    public int addUnsignedShort(long offset, int i) {
        this.checkNotClosed();
        return this.bytes.addUnsignedShort(offset, i);
    }

    @Override
    public int addInt(long offset, int i) {
        this.checkNotClosed();
        return this.bytes.addInt(offset, i);
    }

    @Override
    public long addUnsignedInt(long offset, long i) {
        this.checkNotClosed();
        return this.bytes.addUnsignedInt(offset, i);
    }

    @Override
    public long addLong(long offset, long i) {
        this.checkNotClosed();
        return this.bytes.addLong(offset, i);
    }

    @Override
    public float addFloat(long offset, float f) {
        this.checkNotClosed();
        return this.bytes.addFloat(offset, f);
    }

    @Override
    public double addDouble(long offset, double d) {
        this.checkNotClosed();
        return this.bytes.addDouble(offset, d);
    }

    @Override
    public int addAtomicInt(long offset, int i) {
        this.checkNotClosed();
        return this.bytes.addAtomicInt(offset, i);
    }

    @Override
    public long addAtomicLong(long offset, long delta) {
        this.checkNotClosed();
        return this.bytes.addAtomicLong(offset, delta);
    }

    @Override
    public float addAtomicFloat(long offset, float delta) {
        this.checkNotClosed();
        return this.bytes.addAtomicFloat(offset, delta);
    }

    @Override
    public double addAtomicDouble(long offset, double delta) {
        this.checkNotClosed();
        return this.bytes.addAtomicDouble(offset, delta);
    }

    @Override
    public float readVolatileFloat(long offset) {
        this.checkNotClosed();
        return this.bytes.readVolatileFloat(offset);
    }

    @Override
    public double readVolatileDouble(long offset) {
        this.checkNotClosed();
        return this.bytes.readVolatileDouble(offset);
    }

    @Override
    public void writeOrderedFloat(long offset, float v) {
        this.checkNotClosed();
        this.bytes.writeOrderedFloat(offset, v);
    }

    @Override
    public void writeOrderedDouble(long offset, double v) {
        this.checkNotClosed();
        this.bytes.writeOrderedDouble(offset, v);
    }

    @Override
    public int length() {
        this.checkNotClosed();
        return this.bytes.length();
    }

    @Override
    public char charAt(int index) {
        this.checkNotClosed();
        return this.bytes.charAt(index);
    }

    @Override
    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        this.bytes.readMarshallable(in);
    }

    @Override
    public void writeMarshallable(@NotNull Bytes out) {
        this.checkNotClosed();
        this.bytes.writeMarshallable(out);
    }

    @Override
    public void write(RandomDataInput bytes) {
        this.checkNotClosed();
        this.bytes.write(bytes);
    }

    @Override
    public boolean startsWith(RandomDataInput input) {
        this.checkNotClosed();
        return this.bytes.startsWith(input);
    }

    @Override
    @NotNull
    public String toString() {
        this.checkNotClosed();
        return this.bytes.toString();
    }

    @Override
    @NotNull
    public String toDebugString() {
        this.checkNotClosed();
        return this.bytes.toDebugString();
    }

    @Override
    @NotNull
    public String toDebugString(long limit) {
        this.checkNotClosed();
        return this.bytes.toDebugString(limit);
    }

    @Override
    public void toString(Appendable sb, long start, long position, long end) {
        this.checkNotClosed();
        this.bytes.toString(sb, start, position, end);
    }

    @Override
    public void asString(Appendable appendable) {
        this.checkNotClosed();
        this.bytes.asString(appendable);
    }

    @Override
    public CharSequence asString() {
        this.checkNotClosed();
        return this.bytes.asString();
    }

    @Override
    public boolean compareAndSwapDouble(long offset, double expected, double value) {
        this.checkNotClosed();
        return this.bytes.compareAndSwapDouble(offset, expected, value);
    }

    @Override
    public File file() {
        this.checkNotClosed();
        return this.bytes.file();
    }

    @Override
    public boolean tryRWReadLock(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        return this.bytes.tryRWReadLock(offset, timeOutNS);
    }

    @Override
    public boolean tryRWWriteLock(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        return this.bytes.tryRWWriteLock(offset, timeOutNS);
    }

    @Override
    public void unlockRWReadLock(long offset) {
        this.checkNotClosed();
        this.bytes.unlockRWReadLock(offset);
    }

    @Override
    public void unlockRWWriteLock(long offset) {
        this.checkNotClosed();
        this.bytes.unlockRWWriteLock(offset);
    }

    @Override
    public Bytes slice() {
        this.checkNotClosed();
        return this.bytes.slice();
    }

    @Override
    public Bytes slice(long offset, long length) {
        this.checkNotClosed();
        return this.bytes.slice(offset, length);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.checkNotClosed();
        return this.bytes.subSequence(start, end);
    }

    @Override
    public Bytes bytes() {
        this.checkNotClosed();
        return this.bytes.bytes();
    }

    @Override
    public Bytes bytes(long offset, long length) {
        this.checkNotClosed();
        return this.bytes.bytes(offset, length);
    }

    @Override
    public long address() {
        this.checkNotClosed();
        return this.bytes.address();
    }

    @Override
    public Bytes zeroOut() {
        this.checkNotClosed();
        return this.bytes.zeroOut();
    }

    @Override
    public Bytes zeroOut(long start, long end) {
        this.checkNotClosed();
        return this.bytes.zeroOut(start, end);
    }

    @Override
    public Bytes zeroOut(long start, long end, boolean ifNotZero) {
        this.checkNotClosed();
        return this.bytes.zeroOut(start, end, ifNotZero);
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        this.checkNotClosed();
        return this.bytes.read(bytes, off, len);
    }

    @Override
    public byte readByte() {
        this.checkNotClosed();
        return this.bytes.readByte();
    }

    @Override
    public byte readByte(long offset) {
        this.checkNotClosed();
        return this.bytes.readByte(offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        this.checkNotClosed();
        this.bytes.readFully(b, off, len);
    }

    @Override
    public void readFully(long offset, byte[] bytes, int off, int len) {
        this.checkNotClosed();
        this.bytes.readFully(offset, bytes, off, len);
    }

    @Override
    public void readFully(@NotNull char[] data, int off, int len) {
        this.checkNotClosed();
        this.bytes.readFully(data, off, len);
    }

    @Override
    public short readShort() {
        this.checkNotClosed();
        return this.bytes.readShort();
    }

    @Override
    public short readShort(long offset) {
        this.checkNotClosed();
        return this.bytes.readShort(offset);
    }

    @Override
    public char readChar() {
        this.checkNotClosed();
        return this.bytes.readChar();
    }

    @Override
    public char readChar(long offset) {
        this.checkNotClosed();
        return this.bytes.readChar(offset);
    }

    @Override
    public int readInt() {
        this.checkNotClosed();
        return this.bytes.readInt();
    }

    @Override
    public int readInt(long offset) {
        this.checkNotClosed();
        return this.bytes.readInt(offset);
    }

    @Override
    public int readVolatileInt() {
        this.checkNotClosed();
        return this.bytes.readVolatileInt();
    }

    @Override
    public int readVolatileInt(long offset) {
        this.checkNotClosed();
        return this.bytes.readVolatileInt(offset);
    }

    @Override
    public long readLong() {
        this.checkNotClosed();
        return this.bytes.readLong();
    }

    @Override
    public long readLong(long offset) {
        this.checkNotClosed();
        return this.bytes.readLong(offset);
    }

    @Override
    public long readVolatileLong() {
        this.checkNotClosed();
        return this.bytes.readVolatileLong();
    }

    @Override
    public long readVolatileLong(long offset) {
        this.checkNotClosed();
        return this.bytes.readVolatileLong(offset);
    }

    @Override
    public float readFloat() {
        this.checkNotClosed();
        return this.bytes.readFloat();
    }

    @Override
    public float readFloat(long offset) {
        this.checkNotClosed();
        return this.bytes.readFloat(offset);
    }

    @Override
    public double readDouble() {
        this.checkNotClosed();
        return this.bytes.readDouble();
    }

    @Override
    public double readDouble(long offset) {
        this.checkNotClosed();
        return this.bytes.readDouble(offset);
    }

    @Override
    public void write(int b) {
        this.checkNotClosed();
        this.bytes.write(b);
    }

    @Override
    public void writeByte(long offset, int b) {
        this.checkNotClosed();
        this.bytes.writeByte(offset, b);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        this.checkNotClosed();
        this.bytes.write(offset, bytes);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.checkNotClosed();
        this.bytes.write(bytes, off, len);
    }

    @Override
    public void write(long offset, byte[] bytes, int off, int len) {
        this.checkNotClosed();
        this.bytes.write(offset, bytes, off, len);
    }

    @Override
    public void writeShort(int v) {
        this.checkNotClosed();
        this.bytes.writeShort(v);
    }

    @Override
    public void writeShort(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeShort(offset, v);
    }

    @Override
    public void writeChar(int v) {
        this.checkNotClosed();
        this.bytes.writeChar(v);
    }

    @Override
    public void writeChar(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeChar(offset, v);
    }

    @Override
    public void writeInt(int v) {
        this.checkNotClosed();
        this.bytes.writeInt(v);
    }

    @Override
    public void writeInt(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeInt(offset, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        this.checkNotClosed();
        this.bytes.writeOrderedInt(v);
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        this.checkNotClosed();
        this.bytes.writeOrderedInt(offset, v);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        this.checkNotClosed();
        return this.bytes.compareAndSwapInt(offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        this.checkNotClosed();
        this.bytes.writeLong(v);
    }

    @Override
    public void writeLong(long offset, long v) {
        this.checkNotClosed();
        this.bytes.writeLong(offset, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        this.checkNotClosed();
        this.bytes.writeOrderedLong(v);
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        this.checkNotClosed();
        this.bytes.writeOrderedLong(offset, v);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        this.checkNotClosed();
        return this.bytes.compareAndSwapLong(offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        this.checkNotClosed();
        this.bytes.writeFloat(v);
    }

    @Override
    public void writeFloat(long offset, float v) {
        this.checkNotClosed();
        this.bytes.writeFloat(offset, v);
    }

    @Override
    public void writeDouble(double v) {
        this.checkNotClosed();
        this.bytes.writeDouble(v);
    }

    @Override
    public void writeDouble(long offset, double v) {
        this.checkNotClosed();
        this.bytes.writeDouble(offset, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        this.checkNotClosed();
        this.bytes.readObject(object, start, end);
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        this.checkNotClosed();
        this.bytes.writeObject(object, start, end);
    }

    @Override
    public boolean compare(long offset, RandomDataInput input, long inputOffset, long len) {
        this.checkNotClosed();
        return this.bytes.compare(offset, input, inputOffset, len);
    }

    @Override
    public long position() {
        this.checkNotClosed();
        return this.bytes.position();
    }

    @Override
    public Bytes position(long position) {
        this.checkNotClosed();
        return this.bytes.position(position);
    }

    @Override
    public void write(RandomDataInput bytes, long position, long length) {
        this.checkNotClosed();
        this.bytes.write(bytes, position, length);
    }

    @Override
    public long capacity() {
        this.checkNotClosed();
        return this.bytes.capacity();
    }

    @Override
    public long remaining() {
        this.checkNotClosed();
        return this.bytes.remaining();
    }

    @Override
    public long limit() {
        this.checkNotClosed();
        return this.bytes.limit();
    }

    @Override
    public Bytes limit(long limit) {
        this.checkNotClosed();
        return this.bytes.limit(limit);
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        this.checkNotClosed();
        return this.bytes.byteOrder();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        this.bytes.checkEndOfBuffer();
    }

    @Override
    public Bytes load() {
        this.checkNotClosed();
        return this.bytes.load();
    }

    @Override
    public void alignPositionAddr(int powerOf2) {
        this.checkNotClosed();
        this.bytes.alignPositionAddr(powerOf2);
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        this.checkNotClosed();
        return this.bytes.sliceAsByteBuffer(toReuse);
    }
}

