/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.locks;

import java.nio.ByteOrder;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.locks.NativeAtomicAccess;

final class BytesAtomicAccess
extends NativeAtomicAccess<Bytes> {
    static final BytesAtomicAccess INSTANCE = new BytesAtomicAccess();

    BytesAtomicAccess() {
    }

    @Override
    public long getLongVolatile(Bytes bytes, long offset) {
        long value = bytes.readVolatileLong(offset);
        if (bytes.byteOrder() != ByteOrder.nativeOrder()) {
            value = Long.reverseBytes(value);
        }
        return value;
    }

    @Override
    public void putOrderedLong(Bytes bytes, long offset, long value) {
        if (bytes.byteOrder() != ByteOrder.nativeOrder()) {
            value = Long.reverseBytes(value);
        }
        bytes.writeOrderedLong(offset, value);
    }

    @Override
    public boolean compareAndSwapLong(Bytes bytes, long offset, long expected, long x) {
        if (bytes.byteOrder() != ByteOrder.nativeOrder()) {
            expected = Long.reverseBytes(expected);
            x = Long.reverseBytes(x);
        }
        return bytes.compareAndSwapLong(offset, expected, x);
    }

    @Override
    public int getIntVolatile(Bytes bytes, long offset) {
        int value = bytes.readVolatileInt(offset);
        if (bytes.byteOrder() != ByteOrder.nativeOrder()) {
            value = Integer.reverseBytes(value);
        }
        return value;
    }

    @Override
    public void putOrderedInt(Bytes bytes, long offset, int value) {
        if (bytes.byteOrder() != ByteOrder.nativeOrder()) {
            value = Integer.reverseBytes(value);
        }
        bytes.writeOrderedInt(offset, value);
    }

    @Override
    public boolean compareAndSwapInt(Bytes bytes, long offset, int expected, int x) {
        if (bytes.byteOrder() != ByteOrder.nativeOrder()) {
            expected = Integer.reverseBytes(expected);
            x = Integer.reverseBytes(x);
        }
        return bytes.compareAndSwapInt(offset, expected, x);
    }
}

