/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix;

public class Mapping {
    private final long addr;
    private final long length;
    private final long offset;
    private final long inode;
    private final String perms;
    private final String device;
    private final String path;
    private final String toString;

    public Mapping(String line) {
        String[] parts = line.split(" +");
        String[] addrs = parts[0].split("\\-");
        this.addr = Long.parseUnsignedLong(addrs[0], 16);
        this.length = Long.parseUnsignedLong(addrs[1], 16) - this.addr;
        this.perms = parts[1];
        this.offset = Long.parseUnsignedLong(parts[2], 16);
        this.device = parts[3];
        this.inode = Long.parseLong(parts[4]);
        this.path = parts.length >= 6 ? parts[5] : "";
        this.toString = line;
    }

    public long addr() {
        return this.addr;
    }

    public long length() {
        return this.length;
    }

    public long offset() {
        return this.offset;
    }

    public long inode() {
        return this.inode;
    }

    public String perms() {
        return this.perms;
    }

    public String device() {
        return this.device;
    }

    public String path() {
        return this.path;
    }

    public String toString() {
        return this.toString;
    }
}

