/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import spoon.OutputType;
import spoon.SpoonAPI;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.compiler.Environment;
import spoon.compiler.SpoonCompiler;
import spoon.compiler.SpoonResource;
import spoon.compiler.SpoonResourceHelper;
import spoon.processing.Processor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.support.DefaultCoreFactory;
import spoon.support.JavaOutputProcessor;
import spoon.support.StandardEnvironment;
import spoon.support.compiler.FileSystemFile;
import spoon.support.compiler.FileSystemFolder;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.gui.SpoonModelTree;

public class Launcher
implements SpoonAPI {
    public static final String OUTPUTDIR = "spooned";
    private Factory factory = this.createFactory();
    private SpoonCompiler modelBuilder;
    private String[] commandLineArgs = new String[0];
    private static JSAP jsapSpec = Launcher.defineArgs();
    protected JSAPResult jsapActualArgs;
    private List<String> processorTypes = new ArrayList<String>();
    private List<Processor<? extends CtElement>> processors = new ArrayList<Processor<? extends CtElement>>();
    public static final Logger LOGGER = Logger.getLogger(Launcher.class);
    public static final IOFileFilter RESOURCES_FILE_FILTER = new IOFileFilter(){

        public boolean accept(File file) {
            return !file.getName().endsWith(".java");
        }

        public boolean accept(File file, String s) {
            return false;
        }
    };
    public static final IOFileFilter ALL_DIR_FILTER = new IOFileFilter(){

        public boolean accept(File file) {
            return true;
        }

        public boolean accept(File file, String s) {
            return false;
        }
    };

    public static void main(String[] args) throws Exception {
        new Launcher().run(args);
    }

    @Override
    public void run(String[] args) {
        this.setArgs(args);
        if (args.length != 0) {
            this.run();
            if (this.jsapActualArgs.getBoolean("gui")) {
                new SpoonModelTree(this.getFactory());
            }
        } else {
            this.printUsage();
        }
    }

    public void setArgs(String[] args2) {
        this.commandLineArgs = args2;
        this.processArguments();
    }

    public void printUsage() {
        this.commandLineArgs = new String[]{"--help"};
        this.processArguments();
    }

    public Launcher() {
        this.processArguments();
    }

    @Override
    public void addInputResource(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            this.addInputResource(new FileSystemFolder(file));
        } else {
            this.addInputResource(new FileSystemFile(file));
        }
    }

    private void addInputResource(SpoonResource resource) {
        this.modelBuilder.addInputSource(resource);
    }

    @Override
    public void addProcessor(String name) {
        this.processorTypes.add(name);
    }

    @Override
    public <T extends CtElement> void addProcessor(Processor<T> processor) {
        this.processors.add(processor);
    }

    public void addTemplateResource(SpoonResource resource) {
        this.modelBuilder.addTemplateSource(resource);
    }

    @Override
    public Environment getEnvironment() {
        return this.factory.getEnvironment();
    }

    protected static JSAP defineArgs() {
        try {
            JSAP jsap = new JSAP();
            Switch sw1 = new Switch("help");
            sw1.setShortFlag('h');
            sw1.setLongFlag("help");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("tabs");
            sw1.setLongFlag("tabs");
            sw1.setDefault("false");
            sw1.setHelp("Use tabulations instead of spaces in the generated code (use spaces by default).");
            jsap.registerParameter((Parameter)sw1);
            FlaggedOption opt2 = new FlaggedOption("tabsize");
            opt2.setLongFlag("tabsize");
            opt2.setStringParser((StringParser)JSAP.INTEGER_PARSER);
            opt2.setDefault("4");
            opt2.setHelp("Define tabulation size.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("level");
            opt2.setLongFlag("level");
            opt2.setHelp("Level of the ouput messages about what spoon is doing. Default value is ALL level.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setDefault(Level.OFF.toString());
            jsap.registerParameter((Parameter)opt2);
            sw1 = new Switch("imports");
            sw1.setLongFlag("with-imports");
            sw1.setDefault("false");
            sw1.setHelp("Enable imports in generated files.");
            jsap.registerParameter((Parameter)sw1);
            opt2 = new FlaggedOption("compliance");
            opt2.setLongFlag("compliance");
            opt2.setHelp("Java source code compliance level (1,2,3,4,5, 6, 7 or 8).");
            opt2.setStringParser((StringParser)JSAP.INTEGER_PARSER);
            opt2.setDefault("8");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("encoding");
            opt2.setLongFlag("encoding");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            opt2.setDefault("UTF-8");
            opt2.setHelp("Forces the compiler to use a specific encoding (UTF-8, UTF-16, ...).");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("input");
            opt2.setShortFlag('i');
            opt2.setLongFlag("input");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            opt2.setHelp("List of path to sources files.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("processors");
            opt2.setShortFlag('p');
            opt2.setLongFlag("processors");
            opt2.setHelp("List of processor's qualified name to be used.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("template");
            opt2.setShortFlag('t');
            opt2.setLongFlag("template");
            opt2.setHelp("List of source templates.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            opt2.setHelp("List of path to templates java files.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("output");
            opt2.setShortFlag('o');
            opt2.setLongFlag("output");
            opt2.setDefault(OUTPUTDIR);
            opt2.setHelp("Specify where to place generated java files.");
            opt2.setStringParser((StringParser)FileStringParser.getParser());
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("properties");
            opt2.setLongFlag("properties");
            opt2.setStringParser((StringParser)FileStringParser.getParser());
            opt2.setRequired(false);
            opt2.setHelp("Directory to search for spoon properties files.");
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("source-classpath");
            opt2.setLongFlag("source-classpath");
            opt2.setHelp("An optional classpath to be passed to the internal Java compiler when building or compiling the input sources.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("template-classpath");
            opt2.setLongFlag("template-classpath");
            opt2.setHelp("An optional classpath to be passed to the internal Java compiler when building the template sources.");
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("destination");
            opt2.setShortFlag('d');
            opt2.setLongFlag("destination");
            opt2.setDefault("spooned-classes");
            opt2.setHelp("An optional destination directory for the generated class files.");
            opt2.setStringParser((StringParser)FileStringParser.getParser());
            opt2.setRequired(false);
            jsap.registerParameter((Parameter)opt2);
            opt2 = new FlaggedOption("output-type");
            opt2.setLongFlag(opt2.getID());
            String msg = "States how to print the processed source code: ";
            int i = 0;
            for (OutputType v : OutputType.values()) {
                msg = msg + v.toString();
                if (++i == OutputType.values().length) continue;
                msg = msg + "|";
            }
            opt2.setStringParser((StringParser)JSAP.STRING_PARSER);
            opt2.setHelp(msg);
            opt2.setDefault("classes");
            jsap.registerParameter((Parameter)opt2);
            sw1 = new Switch("compile");
            sw1.setLongFlag(sw1.getUsageName());
            sw1.setHelp("Enable compilation and output class files.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("precompile");
            sw1.setLongFlag("precompile");
            sw1.setHelp("Enable pre-compilation of input source files before processing. Compiled classes will be added to the classpath so that they are accessible to the processing manager (typically, processors, annotations, and templates should be pre-compiled most of the time).");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("buildOnlyOutdatedFiles");
            sw1.setLongFlag("buildOnlyOutdatedFiles");
            sw1.setHelp("Set Spoon to build only the source files that have been modified since the latest source code generation, for performance purpose. Note that this option requires to have the --ouput-type option not set to none. This option is not appropriate to all kinds of processing. In particular processings that implement or rely on a global analysis should avoid this option because the processor will only have access to the outdated source code (the files modified since the latest processing).");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("lines");
            sw1.setLongFlag("lines");
            sw1.setHelp("Set Spoon to try to preserve the original line numbers when generating the source code (may lead to human-unfriendly formatting).");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("noclasspath");
            sw1.setShortFlag('x');
            sw1.setLongFlag("noclasspath");
            sw1.setHelp("Does not assume a full classpath");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("gui");
            sw1.setShortFlag('g');
            sw1.setLongFlag("gui");
            sw1.setHelp("Show spoon model after processing");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("no-copy-resources");
            sw1.setShortFlag('r');
            sw1.setLongFlag("no-copy-resources");
            sw1.setHelp("Disable the copy of resources from source to destination folder.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            sw1 = new Switch("generate-javadoc");
            sw1.setShortFlag('j');
            sw1.setLongFlag("generate-javadoc");
            sw1.setHelp("Enable the generation of the javadoc.");
            sw1.setDefault("false");
            jsap.registerParameter((Parameter)sw1);
            return jsap;
        }
        catch (JSAPException e) {
            throw new SpoonException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected final JSAPResult getArguments() {
        return this.parseArgs();
    }

    protected void processArguments() {
        this.jsapActualArgs = this.getArguments();
        Environment environment = this.factory.getEnvironment();
        environment.setComplianceLevel(this.jsapActualArgs.getInt("compliance"));
        environment.setLevel(this.jsapActualArgs.getString("level"));
        LOGGER.setLevel(environment.getLevel());
        environment.setXmlRootFolder(this.jsapActualArgs.getFile("properties"));
        environment.setAutoImports(this.jsapActualArgs.getBoolean("imports"));
        environment.setNoClasspath(this.jsapActualArgs.getBoolean("noclasspath"));
        environment.setPreserveLineNumbers(this.jsapActualArgs.getBoolean("lines"));
        environment.setTabulationSize(this.jsapActualArgs.getInt("tabsize"));
        environment.useTabulations(this.jsapActualArgs.getBoolean("tabs"));
        environment.setCopyResources(!this.jsapActualArgs.getBoolean("no-copy-resources"));
        environment.setGenerateJavadoc(this.jsapActualArgs.getBoolean("generate-javadoc"));
        environment.setShouldCompile(this.jsapActualArgs.getBoolean("compile"));
        this.modelBuilder = this.createCompiler();
        if (this.getArguments().getString("input") != null) {
            for (String s : this.getArguments().getString("input").split("[" + File.pathSeparatorChar + "]")) {
                try {
                    this.modelBuilder.addInputSource(SpoonResourceHelper.createResource(new File(s)));
                }
                catch (FileNotFoundException e) {
                    throw new SpoonException(e);
                }
            }
        }
        if (this.getArguments().getFile("output") != null) {
            this.setSourceOutputDirectory(this.getArguments().getFile("output"));
        }
        if (this.getArguments().getString("template") != null) {
            for (String s : this.getArguments().getString("template").split("[" + File.pathSeparatorChar + "]")) {
                try {
                    this.modelBuilder.addTemplateSource(SpoonResourceHelper.createResource(new File(s)));
                }
                catch (FileNotFoundException e) {
                    environment.report(null, Level.ERROR, "Unable to add template file: " + e.getMessage());
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.getArguments().getString("processors") != null) {
            for (String processorName : this.getArguments().getString("processors").split(File.pathSeparator)) {
                this.addProcessor(processorName);
            }
        }
    }

    protected List<String> getProcessorTypes() {
        return this.processorTypes;
    }

    protected List<Processor<? extends CtElement>> getProcessors() {
        return this.processors;
    }

    protected JSAPResult parseArgs() {
        if (jsapSpec == null) {
            throw new IllegalStateException("no args, please call setArgs before");
        }
        JSAPResult arguments = jsapSpec.parse(this.commandLineArgs);
        if (!arguments.success()) {
            Iterator errs = arguments.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
        }
        if (!arguments.success() || arguments.getBoolean("help")) {
            System.err.println(this.getVersionMessage());
            System.err.println("Usage: java <launcher name> [option(s)]");
            System.err.println();
            System.err.println("Options : ");
            System.err.println();
            System.err.println(jsapSpec.getHelp());
            System.exit(-1);
        }
        return arguments;
    }

    public SpoonCompiler createCompiler(Factory factory) {
        JDTBasedSpoonCompiler comp = new JDTBasedSpoonCompiler(factory);
        Environment env = this.getEnvironment();
        comp.setEncoding(this.getArguments().getString("encoding"));
        comp.setBuildOnlyOutdatedFiles(this.jsapActualArgs.getBoolean("buildOnlyOutdatedFiles"));
        comp.setBinaryOutputDirectory(this.jsapActualArgs.getFile("destination"));
        comp.setSourceOutputDirectory(this.jsapActualArgs.getFile("output"));
        comp.setEncoding(this.jsapActualArgs.getString("encoding"));
        if (this.jsapActualArgs.contains("source-classpath")) {
            comp.setSourceClasspath(this.jsapActualArgs.getString("source-classpath").split(System.getProperty("path.separator")));
        }
        env.debugMessage("output: " + comp.getSourceOutputDirectory());
        env.debugMessage("destination: " + comp.getBinaryOutputDirectory());
        env.debugMessage("source classpath: " + Arrays.toString(comp.getSourceClasspath()));
        env.debugMessage("template classpath: " + Arrays.toString(comp.getTemplateClasspath()));
        if (this.jsapActualArgs.getBoolean("precompile")) {
            comp.compileInputSources();
        }
        return comp;
    }

    public SpoonCompiler createCompiler(Factory factory, List<SpoonResource> inputSources) {
        SpoonCompiler c = this.createCompiler(factory);
        c.addInputSources(inputSources);
        return c;
    }

    public SpoonCompiler createCompiler(Factory factory, List<SpoonResource> inputSources, List<SpoonResource> templateSources) {
        SpoonCompiler c = this.createCompiler(factory);
        c.addInputSources(inputSources);
        c.addTemplateSources(templateSources);
        return c;
    }

    @Override
    public SpoonCompiler createCompiler() {
        return this.createCompiler(this.factory);
    }

    public SpoonCompiler createCompiler(List<SpoonResource> inputSources) {
        SpoonCompiler c = this.createCompiler(this.factory);
        c.addInputSources(inputSources);
        return c;
    }

    @Override
    public Factory createFactory() {
        return new FactoryImpl(new DefaultCoreFactory(), this.createEnvironment());
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public Environment createEnvironment() {
        return new StandardEnvironment();
    }

    public JavaOutputProcessor createOutputWriter(File sourceOutputDir, Environment environment) {
        return new JavaOutputProcessor(sourceOutputDir, this.createPrettyPrinter());
    }

    public PrettyPrinter createPrettyPrinter() {
        return new DefaultJavaPrettyPrinter(this.getEnvironment());
    }

    @Override
    public void run() {
        Environment env = this.modelBuilder.getFactory().getEnvironment();
        env.reportProgressMessage(this.getVersionMessage());
        env.reportProgressMessage("running Spoon...");
        env.reportProgressMessage("start processing...");
        long t = 0L;
        long tstart = System.currentTimeMillis();
        this.buildModel();
        this.process();
        this.prettyprint();
        if (env.shouldCompile()) {
            this.modelBuilder.compile();
        }
        t = System.currentTimeMillis();
        env.debugMessage("program spooning done in " + (t - tstart) + " ms");
        env.reportEnd();
    }

    private String getVersionMessage() {
        return "Spoon version " + ResourceBundle.getBundle("spoon").getString("application.version");
    }

    @Override
    public void buildModel() {
        long tstart = System.currentTimeMillis();
        this.modelBuilder.build();
        this.getEnvironment().debugMessage("model built in " + (System.currentTimeMillis() - tstart));
    }

    @Override
    public void process() {
        long tstart = System.currentTimeMillis();
        this.modelBuilder.process(this.getProcessorTypes());
        this.modelBuilder.process((Collection<Processor<? extends CtElement>>)this.getProcessors());
        this.getEnvironment().debugMessage("model processed in " + (System.currentTimeMillis() - tstart) + " ms");
    }

    @Override
    public void prettyprint() {
        long tstart = System.currentTimeMillis();
        try {
            OutputType outputType = OutputType.fromString(this.jsapActualArgs.getString("output-type"));
            this.modelBuilder.generateProcessedSourceFiles(outputType);
        }
        catch (Exception e) {
            throw new SpoonException(e);
        }
        if (this.getEnvironment().isCopyResources()) {
            for (File dirInputSource : this.modelBuilder.getInputSources()) {
                if (!dirInputSource.isDirectory()) continue;
                Collection resources = FileUtils.listFiles((File)dirInputSource, (IOFileFilter)RESOURCES_FILE_FILTER, (IOFileFilter)ALL_DIR_FILTER);
                for (Object resource : resources) {
                    String resourceParentPath = ((File)resource).getParent();
                    String packageDir = resourceParentPath.substring(dirInputSource.getPath().length());
                    String targetDirectory = this.modelBuilder.getSourceOutputDirectory() + packageDir;
                    try {
                        FileUtils.copyFileToDirectory((File)((File)resource), (File)new File(targetDirectory));
                    }
                    catch (IOException e) {
                        throw new SpoonException(e);
                    }
                }
            }
        }
        this.getEnvironment().debugMessage("pretty-printed in " + (System.currentTimeMillis() - tstart) + " ms");
    }

    public SpoonModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    @Override
    public void setSourceOutputDirectory(String path) {
        this.setSourceOutputDirectory(new File(path));
    }

    @Override
    public void setSourceOutputDirectory(File outputDirectory) {
        this.modelBuilder.setSourceOutputDirectory(outputDirectory);
        this.getEnvironment().setDefaultFileGenerator(this.createOutputWriter(outputDirectory, this.getEnvironment()));
    }

    @Override
    public void setBinaryOutputDirectory(String path) {
        this.setBinaryOutputDirectory(new File(path));
    }

    @Override
    public void setBinaryOutputDirectory(File outputDirectory) {
        this.modelBuilder.setBinaryOutputDirectory(outputDirectory);
    }
}

