/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;

public class AnnotationFactory
extends TypeFactory {
    public AnnotationFactory(Factory factory) {
        super(factory);
    }

    public <T extends Annotation> CtAnnotationType<?> create(CtPackage owner, String simpleName) {
        CtAnnotationType t = this.factory.Core().createAnnotationType();
        t.setSimpleName(simpleName);
        owner.getTypes().add(t);
        return t;
    }

    public CtAnnotationType<?> create(String qualifiedName) {
        return this.create(this.factory.Package().getOrCreate(this.getPackageName(qualifiedName)), this.getSimpleName(qualifiedName));
    }

    public <T extends Annotation> CtType<T> getAnnotationType(String qualifiedName) {
        return this.get(qualifiedName);
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, CtTypeReference<A> annotationType, String annotationElementName, Object value) {
        return this.annotate(element, annotationType.getActualClass(), annotationElementName, value);
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, Class<A> annotationType, String annotationElementName, Object value) {
        boolean isArray;
        CtAnnotationType annotationtype;
        CtAnnotation<A> annotation = element.getAnnotation(this.factory.Type().createReference(annotationType));
        if (annotation == null) {
            annotation = this.factory.Core().createAnnotation();
            annotation.setAnnotationType(this.factory.Type().createReference(annotationType));
            element.addAnnotation(annotation);
        }
        if ((annotationtype = (CtAnnotationType)annotation.getAnnotationType().getDeclaration()) != null) {
            CtField<?> e = annotationtype.getField(annotationElementName);
            isArray = e.getType() instanceof CtArrayTypeReference;
        } else {
            Method m = null;
            try {
                m = annotation.getAnnotationType().getActualClass().getMethod(annotationElementName, new Class[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("undefined element '" + annotationElementName + "' for annotation '" + annotationType.getName() + "'");
            }
            isArray = m.getReturnType().isArray();
        }
        if (isArray == (value instanceof Collection || value.getClass().isArray())) {
            annotation.addValue(annotationElementName, value);
        } else if (isArray) {
            List l = (List)annotation.getElementValue(annotationElementName);
            l.add(value);
        } else {
            throw new RuntimeException("cannot assing an array to a non-array annotation element");
        }
        return annotation;
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, CtTypeReference<A> annotationType) {
        return this.annotate(element, annotationType.getActualClass());
    }

    public <A extends Annotation> CtAnnotation<A> annotate(CtElement element, Class<A> annotationType) {
        CtAnnotation<A> annotation = element.getAnnotation(this.factory.Type().createReference(annotationType));
        if (annotation == null) {
            annotation = this.factory.Core().createAnnotation();
            annotation.setAnnotationType(this.factory.Type().createReference(annotationType));
            element.addAnnotation(annotation);
        }
        return annotation;
    }
}

