/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class CodeFactory
extends SubFactory {
    public CodeFactory(Factory factory) {
        super(factory);
    }

    public <T> CtBinaryOperator<T> createBinaryOperator(CtExpression<?> left, CtExpression<?> right, BinaryOperatorKind kind) {
        return this.factory.Core().createBinaryOperator().setLeftHandOperand(left).setKind(kind).setRightHandOperand(right);
    }

    public <T> CtFieldAccess<Class<T>> createClassAccess(CtTypeReference<T> type) {
        CtTypeReference<Class> classType = this.factory.Type().createReference(Class.class);
        CtFieldReference field = (CtFieldReference)this.factory.Core().createFieldReference().setDeclaringType(type).setType(classType).setSimpleName("class");
        return (CtFieldAccess)((CtFieldRead)this.factory.Core().createFieldRead().setType(classType)).setVariable(field);
    }

    public <T> CtInvocation<T> createInvocation(CtExpression<?> target, CtExecutableReference<T> executable, CtExpression<?> ... arguments) {
        ArrayList ext = new ArrayList(arguments.length);
        Collections.addAll(ext, arguments);
        return this.createInvocation(target, executable, ext);
    }

    public <T> CtInvocation<T> createInvocation(CtExpression<?> target, CtExecutableReference<T> executable, List<CtExpression<?>> arguments) {
        return (CtInvocation)((CtInvocation)((CtInvocation)this.factory.Core().createInvocation().setTarget(target)).setExecutable(executable)).setArguments(arguments);
    }

    public <T> CtLiteral<T> createLiteral(T value) {
        return this.factory.Core().createLiteral().setValue(value);
    }

    public <T> CtNewArray<T[]> createLiteralArray(T[] value) {
        if (!value.getClass().isArray()) {
            throw new RuntimeException("value is not an array");
        }
        if (value.getClass().getComponentType().isArray()) {
            throw new RuntimeException("can only create one-dimension arrays");
        }
        CtTypeReference<?> componentTypeRef = this.factory.Type().createReference(value.getClass().getComponentType());
        CtArrayTypeReference<?[]> arrayReference = this.factory.Type().createArrayReference(componentTypeRef);
        CtNewArray array = (CtNewArray)this.factory.Core().createNewArray().setType(arrayReference);
        for (T e : value) {
            CtLiteral<T> l = this.factory.Core().createLiteral();
            l.setValue(e);
            array.addElement(l);
        }
        return array;
    }

    public <T> CtLocalVariable<T> createLocalVariable(CtTypeReference<T> type, String name, CtExpression<T> defaultExpression) {
        return (CtLocalVariable)((CtLocalVariable)((CtLocalVariable)this.factory.Core().createLocalVariable().setSimpleName(name)).setType(type)).setDefaultExpression(defaultExpression);
    }

    public <T> CtLocalVariableReference<T> createLocalVariableReference(CtLocalVariable<T> localVariable) {
        CtLocalVariableReference<T> ref = this.factory.Core().createLocalVariableReference();
        ref.setType(localVariable.getType());
        ref.setSimpleName(localVariable.getSimpleName());
        ref.setDeclaration(localVariable);
        return ref;
    }

    public <T> CtLocalVariableReference<T> createLocalVariableReference(CtTypeReference<T> type, String name) {
        return (CtLocalVariableReference)this.factory.Core().createLocalVariableReference().setType(type).setSimpleName(name);
    }

    public <T> CtCatchVariable<T> createCatchVariable(CtTypeReference<T> type, String name) {
        return (CtCatchVariable)((CtCatchVariable)this.factory.Core().createCatchVariable().setSimpleName(name)).setType(type);
    }

    public <T> CtCatchVariableReference<T> createCatchVariableReference(CtCatchVariable<T> catchVariable) {
        return ((CtCatchVariableReference)this.factory.Core().createCatchVariableReference().setType(catchVariable.getType()).setSimpleName(catchVariable.getSimpleName())).setDeclaration(catchVariable);
    }

    public <R> CtStatementList createStatementList(CtBlock<R> block) {
        CtStatementList l = this.factory.Core().createStatementList();
        for (CtStatement s : block.getStatements()) {
            l.addStatement(this.factory.Core().clone(s));
        }
        return l;
    }

    public <T> CtThisAccess<T> createThisAccess(CtTypeReference<T> type) {
        return (CtThisAccess)this.factory.Core().createThisAccess().setType(type);
    }

    public <T> CtVariableAccess<T> createVariableRead(CtVariableReference<T> variable, boolean isStatic) {
        CtVariableRead<T> va;
        if (variable instanceof CtFieldReference) {
            va = this.factory.Core().createFieldRead();
            if (!isStatic) {
                ((CtFieldAccess)va).setTarget(this.createThisAccess(((CtFieldReference)variable).getDeclaringType()));
            }
        } else {
            va = this.factory.Core().createVariableRead();
        }
        return (CtVariableAccess)va.setVariable(variable).setType(variable.getType());
    }

    public List<CtExpression<?>> createVariableReads(List<? extends CtVariable<?>> variables) {
        ArrayList result = new ArrayList(variables.size());
        for (CtVariable<?> v : variables) {
            result.add(this.createVariableRead((CtVariableReference)v.getReference(), v.getModifiers().contains((Object)ModifierKind.STATIC)));
        }
        return result;
    }

    public <A, T extends A> CtAssignment<A, T> createVariableAssignment(CtVariableReference<A> variable, boolean isStatic, CtExpression<T> expression) {
        CtVariableAccess<A> vaccess = this.createVariableRead(variable, isStatic);
        return ((CtAssignment)this.factory.Core().createAssignment().setAssignment(expression)).setAssigned(vaccess);
    }

    public <T> CtStatementList createVariableAssignments(List<? extends CtVariable<T>> variables, List<? extends CtExpression<T>> expressions) {
        CtStatementList result = this.factory.Core().createStatementList();
        for (int i = 0; i < variables.size(); ++i) {
            result.addStatement(this.createVariableAssignment((CtVariableReference)variables.get(i).getReference(), variables.get(i).getModifiers().contains((Object)ModifierKind.STATIC), expressions.get(i)));
        }
        return result;
    }

    public <T> CtField<T> createCtField(String name, CtTypeReference<T> type, String exp, ModifierKind ... visibilities) {
        return (CtField)((CtField)((CtField)((CtField)this.factory.Core().createField().setModifiers(this.modifiers(visibilities))).setSimpleName(name)).setType(type)).setDefaultExpression(this.createCodeSnippetExpression(exp));
    }

    public <T extends CtStatement> CtBlock<?> createCtBlock(T element) {
        return (CtBlock)this.factory.Core().createBlock().addStatement(element);
    }

    public CtThrow createCtThrow(String thrownExp) {
        return this.factory.Core().createThrow().setThrownExpression(this.createCodeSnippetExpression(thrownExp));
    }

    public CtCatch createCtCatch(String nameCatch, Class<? extends Throwable> exception, CtBlock<?> ctBlock) {
        CtCatchVariable catchVariable = (CtCatchVariable)((CtCatchVariable)this.factory.Core().createCatchVariable().setType(this.createCtTypeReference(exception))).setSimpleName(nameCatch);
        return this.factory.Core().createCatch().setParameter(catchVariable).setBody(ctBlock);
    }

    public <T> CtTypeReference<T> createCtTypeReference(Class<?> originalClass) {
        return ((CtTypeReference)this.factory.Core().createTypeReference().setSimpleName(originalClass.getSimpleName())).setPackage(this.createCtPackageReference(originalClass.getPackage()));
    }

    public CtPackageReference createCtPackageReference(Package originalPackage) {
        return (CtPackageReference)this.factory.Core().createPackageReference().setSimpleName(originalPackage.getName());
    }

    public <R extends CtReference, E extends CtNamedElement> List<R> getReferences(List<E> elements) {
        ArrayList<CtReference> refs = new ArrayList<CtReference>(elements.size());
        for (CtNamedElement e : elements) {
            refs.add(e.getReference());
        }
        return refs;
    }

    public Set<ModifierKind> modifiers(ModifierKind ... modifiers) {
        EnumSet<ModifierKind> ret = EnumSet.noneOf(ModifierKind.class);
        Collections.addAll(ret, modifiers);
        return ret;
    }

    public <T> CtCodeSnippetExpression<T> createCodeSnippetExpression(String expression) {
        CtCodeSnippetExpression e = this.factory.Core().createCodeSnippetExpression();
        e.setValue(expression);
        return e;
    }

    public CtCodeSnippetStatement createCodeSnippetStatement(String statement) {
        CtCodeSnippetStatement e = this.factory.Core().createCodeSnippetStatement();
        e.setValue(statement);
        return e;
    }
}

