/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.Import;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.reflect.cu.ImportImpl;

public class CompilationUnitFactory
extends SubFactory {
    Map<String, CompilationUnit> compilationUnits = new TreeMap<String, CompilationUnit>();

    public CompilationUnitFactory(Factory factory) {
        super(factory);
    }

    public Map<String, CompilationUnit> getMap() {
        return this.compilationUnits;
    }

    public CompilationUnit create() {
        CompilationUnit cu = this.factory.Core().createCompilationUnit();
        return cu;
    }

    public CompilationUnit create(String filePath) {
        CompilationUnit cu = this.compilationUnits.get(filePath);
        if (cu == null) {
            if ("".equals(filePath)) {
                cu = this.factory.Core().createVirtualCompilationUnit();
                return cu;
            }
            cu = this.factory.Core().createCompilationUnit();
            cu.setFile(new File(filePath));
            this.compilationUnits.put(filePath, cu);
        }
        return cu;
    }

    public Import createImport(CtTypeReference<?> type) {
        return new ImportImpl(type);
    }

    public Import createImport(Class<?> type) {
        return new ImportImpl(this.factory.Type().createReference(type));
    }

    public Import createImport(CtFieldReference<?> field) {
        return new ImportImpl(field);
    }

    public Import createImport(CtPackageReference pack) {
        return new ImportImpl(pack);
    }
}

