/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtPackageImpl;

public class PackageFactory
extends SubFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CtPackage rootPackage = new CtRootPackage();
    CtPackageReference topLevel;

    public PackageFactory(Factory factory) {
        super(factory);
        this.rootPackage.setFactory(factory);
    }

    public CtPackageReference createReference(CtPackage pack) {
        if (pack == null) {
            throw new IllegalArgumentException();
        }
        return this.createReference(pack.getQualifiedName());
    }

    public CtPackageReference createReference(Package pack) {
        return this.createReference(pack.getName());
    }

    public CtPackageReference topLevel() {
        if (this.topLevel == null) {
            this.topLevel = this.createReference("unnamed package");
        }
        return this.topLevel;
    }

    public CtPackageReference createReference(String name) {
        CtPackageReference ref = this.factory.Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    public CtPackage create(CtPackage parent, String simpleName) {
        return this.getOrCreate(parent.toString() + "." + simpleName);
    }

    public CtPackage getOrCreate(String qualifiedName) {
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage last = this.rootPackage;
        while (token.hasMoreElements()) {
            String name = token.nextToken();
            CtPackage next = last.getPackage(name);
            if (next == null) {
                next = this.factory.Core().createPackage();
                next.setSimpleName(name);
                next.setParent(last);
                last.getPackages().add(next);
            }
            last = next;
        }
        return last;
    }

    public CtPackage get(String qualifiedName) {
        if (qualifiedName.contains("$")) {
            throw new RuntimeException("Invalid package name " + qualifiedName);
        }
        StringTokenizer token = new StringTokenizer(qualifiedName, ".");
        CtPackage current = this.rootPackage;
        if (token.hasMoreElements()) {
            for (current = current.getPackage(token.nextToken()); token.hasMoreElements() && current != null; current = current.getPackage(token.nextToken())) {
            }
        }
        return current;
    }

    public Collection<CtPackage> getAll() {
        return this.getSubPackageList(this.rootPackage);
    }

    public CtPackage getRootPackage() {
        return this.rootPackage;
    }

    private List<CtPackage> getSubPackageList(CtPackage pack) {
        ArrayList<CtPackage> packs = new ArrayList<CtPackage>();
        packs.add(pack);
        for (CtPackage p : pack.getPackages()) {
            packs.addAll(this.getSubPackageList(p));
        }
        return packs;
    }

    private static class CtRootPackage
    extends CtPackageImpl {
        private CtRootPackage() {
            this.setSimpleName("unnamed package");
            this.setParent(new CtElementImpl(){

                @Override
                public void accept(CtVisitor visitor) {
                }

                @Override
                public CtElement getParent() throws ParentNotInitializedException {
                    return null;
                }
            });
        }

        @Override
        public String getSimpleName() {
            return "";
        }

        @Override
        public String getQualifiedName() {
            return "";
        }
    }
}

