/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;

public class TypeFactory
extends SubFactory {
    CtTypeReference<?> nullType;
    public final CtTypeReference<Void> VOID = this.createReference(Void.class);
    public final CtTypeReference<String> STRING = this.createReference(String.class);
    public final CtTypeReference<Boolean> BOOLEAN = this.createReference(Boolean.class);
    public final CtTypeReference<Byte> BYTE = this.createReference(Byte.class);
    public final CtTypeReference<Character> CHARACTER = this.createReference(Character.class);
    public final CtTypeReference<Integer> INTEGER = this.createReference(Integer.class);
    public final CtTypeReference<Long> LONG = this.createReference(Long.class);
    public final CtTypeReference<Float> FLOAT = this.createReference(Float.class);
    public final CtTypeReference<Double> DOUBLE = this.createReference(Double.class);
    public final CtTypeReference<Void> VOID_PRIMITIVE = this.createReference(Void.TYPE);
    public final CtTypeReference<Boolean> BOOLEAN_PRIMITIVE = this.createReference(Boolean.TYPE);
    public final CtTypeReference<Byte> BYTE_PRIMITIVE = this.createReference(Byte.TYPE);
    public final CtTypeReference<Character> CHARACTER_PRIMITIVE = this.createReference(Character.TYPE);
    public final CtTypeReference<Integer> INTEGER_PRIMITIVE = this.createReference(Integer.TYPE);
    public final CtTypeReference<Long> LONG_PRIMITIVE = this.createReference(Long.TYPE);
    public final CtTypeReference<Float> FLOAT_PRIMITIVE = this.createReference(Float.TYPE);
    public final CtTypeReference<Double> DOUBLE_PRIMITIVE = this.createReference(Double.TYPE);
    public final CtTypeReference<Date> DATE = this.createReference(Date.class);
    public final CtTypeReference<Object> OBJECT = this.createReference(Object.class);

    public CtTypeReference<?> nullType() {
        if (this.nullType == null) {
            this.nullType = this.createReference("<nulltype>");
        }
        return this.nullType;
    }

    public TypeFactory(Factory factory) {
        super(factory);
    }

    public <T> CtArrayTypeReference<T[]> createArrayReference(CtType<T> type) {
        CtArrayTypeReference<T[]> array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(this.createReference(type));
        return array;
    }

    public <T> CtArrayTypeReference<T[]> createArrayReference(CtTypeReference<T> reference) {
        CtArrayTypeReference<T[]> array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(reference);
        return array;
    }

    public CtArrayTypeReference<?> createArrayReference(CtTypeReference<?> reference, int n) {
        CtArrayTypeReference<?> componentType = null;
        if (n == 1) {
            return this.createArrayReference(reference);
        }
        componentType = this.createArrayReference(reference, n - 1);
        CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(componentType);
        return array;
    }

    public <T> CtArrayTypeReference<T> createArrayReference(String qualifiedName) {
        CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(this.createReference(qualifiedName));
        return array;
    }

    public <T> CtTypeReference<T> createReference(Class<T> type) {
        if (type.isArray()) {
            CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
            array.setComponentType(this.createReference(type.getComponentType()));
            return array;
        }
        return this.createReference(type.getName());
    }

    public <T> CtTypeReference<T> createReference(CtType<T> type) {
        CtTypeReference ref = this.factory.Core().createTypeReference();
        if (type.getPackage() != null) {
            ref.setPackage(this.factory.Package().createReference(type.getPackage()));
        }
        if (type.getDeclaringType() != null) {
            ref.setDeclaringType(this.createReference(type.getDeclaringType()));
        }
        ref.setSimpleName(type.getSimpleName());
        return ref;
    }

    public <T> CtTypeReference<T> createReference(String qualifiedName) {
        if (qualifiedName.endsWith("[]")) {
            return this.createArrayReference(qualifiedName.substring(0, qualifiedName.length() - 2));
        }
        CtTypeReference ref = this.factory.Core().createTypeReference();
        if (this.hasInnerType(qualifiedName) > 0) {
            ref.setDeclaringType(this.createReference(this.getDeclaringTypeName(qualifiedName)));
        } else if (this.hasPackage(qualifiedName) > 0) {
            ref.setPackage(this.factory.Package().createReference(this.getPackageName(qualifiedName)));
        }
        ref.setSimpleName(this.getSimpleName(qualifiedName));
        return ref;
    }

    public <T> CtType<T> get(String qualifiedName) {
        int inertTypeIndex = qualifiedName.lastIndexOf("$");
        if (inertTypeIndex > 0) {
            String s = qualifiedName.substring(0, inertTypeIndex);
            CtType<T> t = this.get(s);
            if (t == null) {
                return null;
            }
            return t.getNestedType(qualifiedName.substring(inertTypeIndex + 1));
        }
        int packageIndex = qualifiedName.lastIndexOf(".");
        CtPackage pack = packageIndex > 0 ? this.factory.Package().get(qualifiedName.substring(0, packageIndex)) : this.factory.Package().get("unnamed package");
        if (pack == null) {
            return null;
        }
        return pack.getType(qualifiedName.substring(packageIndex + 1));
    }

    public List<CtType<?>> getAll() {
        ArrayList types = new ArrayList();
        for (CtPackage pack : this.factory.Package().getAll()) {
            types.addAll(pack.getTypes());
        }
        return types;
    }

    public List<CtType<?>> getAll(boolean includeNestedTypes) {
        if (!includeNestedTypes) {
            return this.getAll();
        }
        ArrayList types = new ArrayList();
        for (CtPackage pack : this.factory.Package().getAll()) {
            for (CtType<?> type : pack.getTypes()) {
                this.addNestedType(types, type);
            }
        }
        return types;
    }

    private void addNestedType(List<CtType<?>> list, CtType<?> t) {
        list.add(t);
        for (CtType<?> nt : t.getNestedTypes()) {
            this.addNestedType(list, nt);
        }
    }

    public <T> CtType<T> get(Class<?> cl) {
        return this.get(cl.getName());
    }

    protected String getDeclaringTypeName(String qualifiedName) {
        return qualifiedName.substring(0, this.hasInnerType(qualifiedName));
    }

    public List<CtTypeReference<?>> createReferences(List<Class<?>> classes) {
        ArrayList refs = new ArrayList(classes.size());
        for (Class<?> c : classes) {
            refs.add(this.createReference(c));
        }
        return refs;
    }

    protected String getPackageName(String qualifiedName) {
        if (this.hasPackage(qualifiedName) >= 0) {
            return qualifiedName.substring(0, this.hasPackage(qualifiedName));
        }
        return "unnamed package";
    }

    protected String getSimpleName(String qualifiedName) {
        if (this.hasInnerType(qualifiedName) > 0) {
            return qualifiedName.substring(this.hasInnerType(qualifiedName) + 1);
        }
        if (this.hasPackage(qualifiedName) > 0) {
            return qualifiedName.substring(this.hasPackage(qualifiedName) + 1);
        }
        return qualifiedName;
    }

    protected int hasInnerType(String qualifiedName) {
        int ret = qualifiedName.lastIndexOf("$");
        return ret;
    }

    protected int hasPackage(String qualifiedName) {
        return qualifiedName.lastIndexOf(".");
    }

    public CtTypeParameter createTypeParameter(CtElement owner, String name) {
        CtTypeParameter typeParam = this.factory.Core().createTypeParameter();
        typeParam.setSimpleName(name);
        return typeParam;
    }

    public CtTypeParameter createTypeParameter(CtElement owner, String name, List<CtTypeReference<?>> bounds) {
        CtTypeParameter typeParam = this.factory.Core().createTypeParameter();
        typeParam.setSimpleName(name);
        typeParam.setBounds(bounds);
        return typeParam;
    }

    public CtTypeParameterReference createTypeParameterReference(String name) {
        CtTypeParameterReference typeParam = this.factory.Core().createTypeParameterReference();
        typeParam.setSimpleName(name);
        return typeParam;
    }

    public CtTypeParameterReference createTypeParameterReference(String name, List<CtTypeReference<?>> bounds) {
        CtTypeParameterReference typeParam = this.factory.Core().createTypeParameterReference();
        typeParam.setSimpleName(name);
        typeParam.setBounds(bounds);
        return typeParam;
    }
}

